(function ($) {
	function updateProductImportInfo(value, product_id) {
		$.ajax(
			{
				url: empik_woocommerce.admin_url,
				type: 'post',
				data: {
					action: 'empik_woocommerce_select_products_to_export',
					import_product: {
						'value': value,
						'product_id': product_id
					}
				},
				success:
					function (response) {

						if (typeof response.status === 'undefined') {

							return false;
						}

						if (response.status === 'error') {

							return false;
						}

						if (response.status === 'success') {

							return true;
						}
					}
			}
		);

	}

	function updateOfferImportInfo(value, product_id) {
		$.ajax(
			{
				url: empik_woocommerce.admin_url,
				type: 'post',
				data: {
					action: 'empik_woocommerce_select_offers_to_export',
					import_offer: {
						'value': value,
						'product_id': product_id
					}
				},
				success:
					function (response) {

						if (typeof response.status === 'undefined') {

							return false;
						}

						if (response.status === 'error') {

							return false;
						}

						if (response.status === 'success') {

							return true;
						}
					}
			}
		);

	}

	function submitCarrierInfo(value, order_id) {

		let import_response;

		let ajax_data = {
			action: 'empik_woocommerce_carrier_info',
			info_code: $( '#empik_woocommerce_carrier_info_code' ).val(),
			info_name: $( "#empik_woocommerce_carrier_info_code option:selected" ).text(),
			info_url: $( '#empik_woocommerce_carrier_info_url' ).val(),
			info_number: $( '#empik_woocommerce_carrier_info_number' ).val(),
			order_id: $( '#empik_woocommerce_carrier_info_order_id' ).val(),
			security: $( '#empik_carrier_update' ).val()
		};

		$.ajax(
			{
				url: empik_woocommerce.admin_url,
				type: 'post',
				async: false,
				data: ajax_data,
				success:
					function (response) {
						import_response = response;
					}

			}
		);

		return import_response;

	}

	$( '.empik_woocommerce_select_products_to_export' ).click(
		function () {
			var checked = this.checked;
			updateProductImportInfo( checked, $( this ).data( 'id' ) )
		}
	);

	$( '.empik_woocommerce_select_offers_to_export' ).click(
		function () {
			var checked = this.checked;
			updateOfferImportInfo( checked, $( this ).data( 'id' ) )
		}
	);

	// products.
	$( '#empik_woocommerce_button_export_products' ).click(
		function (e) {
			e.preventDefault();

			$( '#empik_response' ).remove();
			$( '.empik-ajax-procent' ).html( '' );
			$( '.empik-ajax-procent' ).css( 'visibility', 'visible' );
			let is_all = $( '#empik_woocommerce_set_export_products_all' ).is( ':checked' );

			var currentDate = new Date(),
				day         = currentDate.getDate(),
				month       = currentDate.getMonth() + 1,
				year        = currentDate.getFullYear(),
				timestamp   = currentDate.getTime(),
				filename    = 'wc-product-export-' + day + '-' + month + '-' + year + '-' + timestamp + '.csv';

			export_by_step( 1, '', '', filename, is_all );

			return false;
		}
	);

	$( '#empik_woocommerce_carrier_info_btn' ).click(
		function (e) {
			e.preventDefault();
			let submit_response = submitCarrierInfo()

			if (submit_response.status === 'error') {
				var color = "#b41a1a";
			}

			if (submit_response.status === 'success') {
				var color = "#25872a";
			}

			$( this ).after( "<p style='color: " + color + "'>" + submit_response.message + "</p>" );

			return false;
		}
	);

	// offers.
	$( '#empik_woocommerce_button_export_offers' ).click(
		function (e) {

			e.preventDefault();
			$.ajax(
				{
					url: empik_woocommerce.admin_url,
					type: 'post',
					async: true,
					data: {
						action: 'empik_woocommerce_offers_export',
						price_percentage_multiplier: $( '#empik_woocommerce_set_offers_price_multiplier' ).val(),
						price_add_value: $( '#empik_woocommerce_set_offers_add_to_price' ).val(),
						add_logistic_class: $( '#empik_woocommerce_set_export_logistic_class' ).is( ':checked' ),
						add_product_state: $( '#empik_woocommerce_set_export_product_states' ).is( ':checked' ),
						price_from_product: $( 'input[name="empik_woocommerce_set_export_offers_from"]:checked' ).val(),
						security: $( '#empik-export-nonce' ).attr( 'data-id' )

					},
					beforeSend() {
						$( '.empik-ajax-run' ).css( 'visibility', 'visible' );
					},
					success:
						function (response) {
							$( '.empik-ajax-run' ).css( 'visibility', 'hidden' );

							if (response.status === 'error') {
								var color = "#b41a1a";
							}

							if (response.status === 'success') {
								var color = "#25872a";
							}

							$( '.empik-ajax-run' ).after( "<p style='color: " + color + "'>" + response.message + "</p>" );
						},
					complete:
						function (response) {
							$( '.empik-ajax-run' ).css( 'visibility', 'hidden' );
							console.log( 'Empik API response for offers export:' );
							console.log( response );
						}

				}
			);

			return false;
		}
	);

	$( '#empik_woocommerce_button_import_orders' ).click(
		function (e) {
			e.preventDefault();
			$( '.empik_woocommerce_debug' ).remove();

			$.ajax(
				{
					url: empik_woocommerce.admin_url,
					type: 'post',
					async: true,
					data: {
						action: 'empik_woocommerce_orders_import',
					},
					success:
						function (response) {

							if (response.status === 'error') {
								var color = "#b41a1a";
							}

							if (response.status === 'success') {
								var color = "#25872a";
							}

							$( '.empik-ajax-run' ).after( "<p class='empik_woocommerce_debug' style='color: " + color + "'>" + response.message + "</p>" );
						}

				}
			);

			return false;
		}
	);

	$( document ).ready(
		function () {

			let connection_button_input = $( '#empik_woocommerce_set_import_connection_test_BTN' );

			let empik_connection_button = '<button id="empik_woocommerce_button_connection_test" class="button il-empik-btn" style="margin-top:20px;margin-right:2500px;">'
				+ empik_woocommerce.connection_btn_text +
				'</button>' +
				'<p class="empik-preloader-wrapper">' +
				'<span style="float:unset;margin-top: 20px;visibility: hidden;" class="empik-ajax-run spinner is-active"></span>' +
				'<span class="empik-ajax-procent" style="float:unset;margin-top: 20px;position:absolute"></span>' +
				'</p>';

			connection_button_input.replaceWith( empik_connection_button );

			let cron_type_radio = $( 'input[name="empik_woocommerce_set_cron_type"]' );
			if (typeof cron_type_radio != 'undefined' && cron_type_radio !== null) {
				let cron_type = $( 'input[name="empik_woocommerce_set_cron_type"]:checked' ).val();
				if ( '1' === cron_type ) {
					$( '.empik_server_cron_endpoints' ).each(
						function (i, elem) {
							$( elem ).css( 'display', 'none' );
						}
					);
					$( '.empik_server_wp_cron' ).each(
						function (i, elem) {
							$( elem ).css( 'display', 'block' );
						}
					);
				} else {
					$( '.empik_server_cron_endpoints' ).each(
						function (i, elem) {
							$( elem ).css( 'display', 'block' );
						}
					);
					$( '.empik_server_wp_cron' ).each(
						function (i, elem) {
							$( elem ).css( 'display', 'none' );
						}
					);
				}
			}

			let price_source_option = $( 'input[name="empik_woocommerce_set_export_offers_from"]:checked' );
			let price_source_notice = '<p class="empik-price-source-notice"><i>' + empik_woocommerce.price_notice + '</i></p>';
			if (typeof price_source_option != 'undefined' && price_source_option !== null) {
				if (+$( price_source_option ).val() === 1) {
					let label = $( 'input[name="empik_woocommerce_set_export_offers_from"]:checked' ).parent( 'label' );
					if (typeof label != 'undefined' && label !== null) {
						$( label ).append( price_source_notice );
					}
				}
			}

			$( 'input[name="empik_woocommerce_set_export_offers_from"]' ).on(
				'change',
				function () {
					if ($( this ).is( ':checked' )) {
						if (+$( this ).val() === 1) {
							let label = $( this ).parent( 'label' );
							if (typeof label != 'undefined' && label !== null) {
								$( label ).append( price_source_notice );
							}
						} else {
							$( '.empik-price-source-notice' ).each(
								function (ind, elem) {
									$( elem ).remove();
								}
							);
						}
					}
				}
			);

			let attention_label = $( 'label[for="empik_woocommerce_set_export_logistic_class"]' );
			if (typeof attention_label != 'undefined' && attention_label !== null) {
				$( attention_label ).parent( 'fieldset' ).prepend( '<p style="font-size:18px;margin-bottom:10px;" class="empik-attention-title">' + empik_woocommerce.klasa_title + '</p>' );

				$( attention_label ).parent( 'fieldset' ).css( 'padding', '10px' );
				$( attention_label ).parent( 'fieldset' ).css( 'margin-top', '10px' );
			}

			let attention_label_state = $( 'label[for="empik_woocommerce_set_export_product_states"]' );
			if (typeof attention_label_state != 'undefined' && attention_label_state !== null) {
				$( attention_label_state ).parent( 'fieldset' ).prepend( '<p style="font-size:18px;margin-bottom:10px;" class="empik-attention-title">' + empik_woocommerce.state_title + '</p>' );

				$( attention_label_state ).parent( 'fieldset' ).css( 'padding', '10px' );
				$( attention_label_state ).parent( 'fieldset' ).css( 'margin-top', '10px' );
			}

			let second_block = $( '.empik_source_prices' );
			if (typeof second_block[0] != 'undefined' && second_block[0] !== null) {
				let block_parent_ul = $( second_block[0] ).closest( 'ul' );
				if (typeof block_parent_ul != 'undefined' && block_parent_ul !== null) {
					$( block_parent_ul ).prev( 'p' ).css( 'font-size', '18px' );
					$( block_parent_ul ).prev( 'p' ).css( 'margin-bottom', '10px' );
				}
			}

			$( 'input[name="empik_woocommerce_set_cron_type"]' ).on(
				'change',
				function (e) {
					if ( '1' === $( this ).val() ) {
						$( '.empik_server_cron_endpoints' ).each(
							function (i, elem) {
								$( elem ).css( 'display', 'none' );
							}
						);
						$( '.empik_server_wp_cron' ).each(
							function (i, elem) {
								$( elem ).css( 'display', 'block' );
							}
						);
					} else {
						$( '.empik_server_cron_endpoints' ).each(
							function (i, elem) {
								$( elem ).css( 'display', 'block' );
							}
						);
						$( '.empik_server_wp_cron' ).each(
							function (i, elem) {
								$( elem ).css( 'display', 'none' );
							}
						);
					}
				}
			);

			$( '.empik-export-bulk-product, .empik-export-bulk-offer' ).on(
				'click',
				function (e) {
					e.preventDefault();

					if ($( this ).attr( 'data-active' )) {
						alert( 'Poczekaj na zakończenie poprzedniej operacji' );
						return;

					} else {
						$( '.empik-export-bulk-offer' ).each(
							function (i, el) {
								$( el ).attr( 'data-active', true );
							}
						);
						$( '.empik-export-bulk-product' ).each(
							function (i, el) {
								$( el ).attr( 'data-active', true );
							}
						)
					}

					let status        = $( this ).attr( 'data-id' );
					let type          = $( this ).attr( 'data-type' );
					let form          = $( '#posts-filter' );
					let selected_data = animate_table_processing( type );

					if (typeof selected_data != 'undefined' && selected_data !== null) {
						if (Object.keys( selected_data.products ).length) {
							process_selected_item( selected_data.products, 1, selected_data.selected_row_count, form, 0, type, status );
						}
					}
				}
			);
		}
	);

	function process_selected_item(products, index, total, form, failed, type, status) {

		// if total reached.
		if (index > total) {
			return false;
		}

		let product_id = products[index];

		// avoid to proccess products which already has status we need.
		if ((status && ! $( '#empik_woocommerce_select_' + type + 's_to_export_' + product_id ).prop( 'checked' ))
			|| ( ! status && $( '#empik_woocommerce_select_' + type + 's_to_export_' + product_id ).prop( 'checked' ))
		) {

			let data = {};
			if (type === 'product') {
				data = {
					action: 'empik_woocommerce_select_' + type + 's_to_export',
					import_product: {
						'value': status ? 'true' : false,
						'product_id': product_id
					}
				}
			} else {
				data = {
					action: 'empik_woocommerce_select_' + type + 's_to_export',
					import_offer: {
						'value': status ? 'true' : false,
						'product_id': product_id
					}
				}
			}

			$.ajax(
				{
					beforeSend: function () {
					},
					type: 'POST',
					url: empik_woocommerce.admin_url,
					data: data,
					success: function (data) {

						let row_id                   = '#post-' + product_id;
						let input_selector           = '#empik_woocommerce_select_' + type + 's_to_export_' + product_id;
						let empik_custom_column_cell = $( row_id + ' > .empik_woocommerce_select_' + type + 's_to_export_column' );

						$( empik_custom_column_cell ).find( '.empik-export-preloader' ).remove();
						$( input_selector ).show();

						if (data.status === 'success') {
							if (index <= total) {
								process_selected_item( products, (index + 1), total, form, failed, type, status );
							}

						} else {
							failed++;
							// continue with next.
							if (index < total) {
								process_selected_item( products, (index + 1), total, form, failed, type, status );
							}
						}

						// last item.
						if (index == total) {
							alert( 'Produkty zostały oznaczone' );
							$( '.empik-export-bulk-offer' ).each(
								function (i, el) {
									$( el ).attr( 'data-active', '' );
								}
							);
							$( '.empik-export-bulk-product' ).each(
								function (i, el) {
									$( el ).attr( 'data-active', '' );
								}
							)
						}

					}, complete: function (data) {
						let input_selector = '#empik_woocommerce_select_' + type + 's_to_export_' + product_id;

						if (status) {
							$( input_selector ).prop( 'checked', true );
						} else {
							$( input_selector ).prop( 'checked', false );
						}
					}
				}
			);
		} else {
			// last item.
			if (index == total) {
				alert( 'Wszystkie produkty są już oznaczone' );
				$( '.empik-export-bulk-offer' ).each(
					function (i, el) {
						$( el ).attr( 'data-active', '' );
					}
				);
				$( '.empik-export-bulk-product' ).each(
					function (i, el) {
						$( el ).attr( 'data-active', '' );
					}
				)
			}

			let row_id                   = '#post-' + product_id;
			let input_selector           = '#empik_woocommerce_select_' + type + 's_to_export_' + product_id;
			let empik_custom_column_cell = $( row_id + ' > .empik_woocommerce_select_' + type + 's_to_export_column' );

			$( empik_custom_column_cell ).find( '.empik-export-preloader' ).remove();
			$( input_selector ).show();

			process_selected_item( products, (index + 1), total, form, failed, type, status );
		}
	}

	function animate_table_processing(type) {
		let form  = $( '#posts-filter' ),
			table = form.find( 'table' );

		let all_rows = table.find( "th[class='check-column']" ).children( "input[type='checkbox']" );

		let result             = {};
		let selected_row_count = 0;
		let products           = {};
		let index              = 1;
		let empik_checkbox_selector;
		all_rows.each(
			function (i, v) {
				let row_id = '#post-' + $( v ).val();
				let row    = $( row_id );
				if (type === 'product') {
					empik_checkbox_selector = '#empik_woocommerce_select_products_to_export_' + $( v ).val();
				} else {
					empik_checkbox_selector = '#empik_woocommerce_select_offers_to_export_' + $( v ).val();
				}
				$( empik_checkbox_selector ).hide();
				$( empik_checkbox_selector ).parent().append( '<img class="empik-export-preloader" src="/wp-includes/images/wpspin.gif">' );
				selected_row_count++;
				products[index] = $( v ).val();
				index++;
			}
		);

		if (selected_row_count === 0) {
			alert( 'Nie wybrano żadnych produktów' );
			return;
		} else {
			result['selected_row_count'] = selected_row_count;
			result['products']           = products;
			return result;
		}
	}

	function export_by_step(step, data, columns, filename, is_all = false) {

		var $this            = this,
			selected_columns = [],
			export_meta      = 1,
			export_types     = [],
			export_category  = [];
		$.ajax(
			{
				type: 'POST',
				url: empik_woocommerce.admin_url,
				data: {
					form: data,
					action: 'empik_woocommerce_products_export',
					empik_pr_exp_step: step,
					empik_full_columns: columns,
					selected_columns: selected_columns,
					export_meta: export_meta,
					export_types: export_types,
					export_category: export_category,
					filename: filename,
					empik_is_export_all: is_all,
					security: $( '#empik-export-nonce' ).val()
				},
				beforeSend() {
					$( '.empik-ajax-run' ).css( 'visibility', 'visible' );
				},
				dataType: 'json',
				success: function (response) {

					if (typeof response.message != 'undefined' && response.message !== null) {
						var color = "#25872a";
						$( '.empik-ajax-run' ).css( 'visibility', 'hidden' );
						$( '.empik-ajax-procent' ).css( 'visibility', 'hidden' );
						$( '.empik-ajax-procent' ).html( '' );
						$( '.empik-ajax-run' ).after( "<p id='empik_response' style='font-weight:bold; color: " + color + "'>" + response.message + "</p>" );
					}

					if (response.success) {
						$( '.empik-ajax-procent' ).html( '<b>' + response.data.percentage + ' % ' + '</b>' );
						export_by_step( parseInt( response.data.step, 10 ), data, response.data.columns, filename, is_all );
					}
				},
				complete:
					function (response) {
						// console.log('Empik API response for product export:');
						// console.log(response);
					},
				error:
					function (jqXHR, textStatus, errorThrown) {
						$( '.empik-ajax-run' ).css( 'visibility', 'hidden' );
						$( '.empik-ajax-procent' ).css( 'visibility', 'hidden' );
						$( '.empik-ajax-procent' ).html( '' );

						var color = "#b41a1a";
						$( '.empik-ajax-run' ).after( "<p id='empik_response' style='font-weight:bold; color: " + color + "'>Error: " + errorThrown + ' ' + jqXHR.responseText + "</p>" );

					}
			}
		).fail(
			function (response) {
				window.console.log( response );
			}
		);
	}

	document.addEventListener(
		'click',
		function (e) {
			e          = e || window.event;
			let target = e.target;

			if ( target.hasAttribute( 'id' ) && 'empik_woocommerce_button_connection_test' === target.getAttribute( 'id' ) ) {
				e.preventDefault();
				$( '#empik-test-connection-result' ).remove();

				$.ajax(
					{
						url: empik_woocommerce.admin_url,
						type: 'post',
						async: true,
						data: {
							action: 'empik_woocommerce_connection_test',
							security: empik_woocommerce.nonce,
						},
						beforeSend() {
							$( '.empik-ajax-run' ).css( 'visibility', 'visible' );
						},
						success:
						function (response) {
							$( '.empik-ajax-run' ).css( 'visibility', 'hidden' );
							response = response.replace( /[^0-9]/gi, '' );
							if (response === '1') {
								$( '.empik-ajax-run' ).after( "<p id='empik-test-connection-result' style='color: #25872a'>Test połączenia: połączono</p>" );
							} else {
								$( '.empik-ajax-run' ).after( "<p id='empik-test-connection-result' style='color: #b41a1a'>Test połączenia: nieudane</p>" );
							}
						}
					}
				);
			}

		},
		false
	);

})( jQuery );