<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Server;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Plugin;
use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Settings_Ids;

/**
 * Abstract_Api
 */
class Abstract_Api {

	/**
	 * Validates if provided token matches the stored secret token.
	 *
	 * @param string $token The token to validate against stored secret token.
	 * @return bool True if tokens match, false otherwise.
	 */
	protected function validate_secret_token( string $token ): bool {
		return self::get_secret_token() === $token;
	}

	/**
	 * Generates a secret token based on API key and shop ID.
	 *
	 * Creates MD5 hash from concatenated API key and shop ID settings.
	 *
	 * @return string The generated secret token hash.
	 */
	public static function get_secret_token(): string {
		$api_key = Plugin::get_settings()->get_option( Settings_Ids::SETTINGS_ID_API_KEY );
		$shop_id = Plugin::get_settings()->get_option( Settings_Ids::SETTINGS_ID_SHOP_ID );

		return md5( $api_key . $shop_id );
	}
}
