<?php

namespace Inspire_Labs\Empik_Woocommerce\Order;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use DateTime;
use Inspire_Labs\Empik_Woocommerce\Api_Client\Api_Factory;
use Inspire_Labs\Empik_Woocommerce\Plugin;

/**
 * Carrier_List
 */
class Carrier_List {

	const CARRIER_CACHE_OPTION_NAME           = Plugin::APP_PREFIX . 'CARRIER_CACHE';
	const CARRIER_CACHE_TIMESTAMP_OPTION_NAME
		= Plugin::APP_PREFIX . 'CARRIER_CACHE_TIMESTAMP';

	/**
	 * Get from cache
	 *
	 * @return array
	 */
	public function get_from_cache(): array {

		if ( time()
			- (int) get_option( self::CARRIER_CACHE_TIMESTAMP_OPTION_NAME )
			> 86400
		) {
			$carriers = $this->get_from_api();
			update_option( self::CARRIER_CACHE_OPTION_NAME, $carriers );
			update_option( self::CARRIER_CACHE_TIMESTAMP_OPTION_NAME, time() );
		} else {
			$carriers = get_option( self::CARRIER_CACHE_OPTION_NAME );
		}

		return array( 'carriers' => $carriers );
	}


	/**
	 * Get from API list of carriers
	 *
	 * @return array|bool
	 */
	private function get_from_api() {
		return ( new Api_Factory() )->create_service()->sh21_get_all_carriers();
	}
}
