<?php

namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Plugin;

/**
 * Abstract_Ajax
 */
abstract class Abstract_Ajax {
	abstract public function ajax_callback();

	/**
	 * get_context_phrase
	 *
	 * @return string
	 */
	abstract protected function get_context_phrase(): string;

	public function init() {
		add_action( $this->get_ajax_action_name(), array( $this, 'ajax_callback' ) );
	}

	/**
	 * get_ajax_action_name
	 *
	 * @return string
	 */
	protected function get_ajax_action_name(): string {
		return 'wp_ajax_' . $this->get_module_id();
	}

	/**
	 * get_module_id
	 *
	 * @return string
	 */
	private function get_module_id(): string {
		$context_phrase = $this->get_context_phrase();

		return Plugin::APP_PREFIX . '_' . $context_phrase;
	}
}
