<?php 

defined('ABSPATH') or die("you do not have access to this page!");
$this->generic_documents_list = array(
	'cookie-statement' => array(
		'can_region_redirect' => true,
		'title' => __("Cookie Policy", "complianz-gdpr")
	),
	'privacy-statement' =>  array(
		'can_region_redirect' => true,
		'title' => __("Privacy Statement", "complianz-gdpr"),
	),
	'privacy-statement-children' =>  array(
		'can_region_redirect' => true,
		'title' => __("Children's statement", "complianz-gdpr"),
	),
	'impressum' =>  array(
		'can_region_redirect' => false,
		'title' => __("Impressum", "complianz-gdpr"),
	),
	'disclaimer' =>  array(
		'can_region_redirect' => false,
		'title' => __("Disclaimer", "complianz-gdpr"),
	),
);

/**
 * The condition key is used to check if all generated pages are available, the document can still be used if it is set to non-generated by complianz.
 */

$this->pages = array(
	'eu' => array(
	    'cookie-statement' => array(
	        'title' => __("Cookie Policy (EU)", 'complianz-gdpr'),
	        'public' => true,
	        'document_elements' => '',
	        'condition' => array(
	            'cookie-statement' => 'generated',
	        ),
	    ),
	    'privacy-statement' => array(
		    'title' => __("Privacy Statement (EU)", 'complianz-gdpr'),
		    'public' => true,
		    'document_elements' => '',
		    'condition' => array(
			    'privacy-statement' => 'generated',
		    ),
	    ),
	),
	'us' => array(
		'cookie-statement' => array(
			'title' => 'Opt-out preferences',
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (US)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),

	),
	'uk'=> array(
		'cookie-statement' => array(
			'title' => __("Cookie Policy (UK)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (UK)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),
	),
	'ca' => array(
		'cookie-statement' => array(
			'title' => __("Cookie Policy (CA)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (CA)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),
	),
	'au' => array(
		'cookie-statement' => array(
			'title' => 'Cookie Policy (AU)',
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (AU)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),
	),
	'za' => array(
		'cookie-statement' => array(
			'title' => __("Cookie Policy (ZA)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (ZA)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),
	),
	'br' => array(
		'cookie-statement' => array(
			'title' => __("Cookie Policy (BR)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'cookie-statement' => 'generated',
			),
		),
		'privacy-statement' => array(
			'title' => __("Privacy Statement (BR)", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'privacy-statement' => 'generated',
			),
		),
	),
	'all' => array(
		'impressum' => array(
			'title' => __("Imprint", 'complianz-gdpr'),
			'public' => true,
			'document_elements' => '',
			'condition' => array(
				'impressum' => 'generated',
			),
		),

	),
);
