<?php
/**
	Plugin Name: EmpikPlace for Woocommerce
	Plugin URI: https://www.empik.com/empikplace/dlaczego-warto
	Description: Send products, synchronize offers, download and process orders from Empikplace.
	Product: EmpikPlace for Woocommerce
	Version: 1.4.9
	Author: iLabs.dev
	Author URI: https://iLabs.dev/
	License: GPLv3
	License URI: https://www.gnu.org/licenses/gpl-3.0.html
	Text Domain: empik-for-woocommerce
	Domain Path: /lang/

	EmpikPlace for Woocommerce is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	any later version.

	EmpikPlace for Woocommerce is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with EmpikPlace for Woocommerce. If not, see https://www.gnu.org/licenses/gpl-3.0.html.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly.

/* THESE TWO VARIABLES CAN BE CHANGED AUTOMATICALLY */
$plugin_version                        = '1.4.9';
const EMPIK_WOOCOMMERCE_PLUGIN_VERSION = '1.4.9';
const EMPIK_TEST_MODE_ON               = false;

$plugin_name        = 'Empik for Woocommerce';
$plugin_class_name  = '\Inspire_Labs\Empik_Woocommerce\Plugin';
$plugin_text_domain = 'empik-for-woocommerce';
$product_id         = 'empik-for-woocommerce';
$plugin_file        = __FILE__;
$plugin_dir         = __DIR__;

$requirements = array(
	'php'     => '7.0',
	'wp'      => '5.0',
	'plugins' => array(
		array(
			'name'      => 'woocommerce/woocommerce.php',
			'nice_name' => 'WooCommerce',
			'version'   => '4.7',
		),
	),
);

define(
	'EMPIK_WOOCOMMERCE_PLUGIN_PATH',
	plugin_dir_path( __FILE__ )
);

define( 'empik_woocommerce_DEBUG', false );

define(
	'EMPIK_WOOCOMMERCE_PLUGIN_BASENAME',
	plugin_basename( __FILE__ )
);

add_action(
	'after_setup_theme',
	function () {
		load_plugin_textdomain( 'empik-for-woocommerce', false, plugin_basename( __DIR__ ) . '/lang' );
	}
);

require __DIR__ . '/vendor_prefixed/wpdesk/wp-plugin-flow/src/plugin-init-php52-free.php';
