<?php

namespace Inspire_Labs\Empik_Woocommerce\Api_Client;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Plugin;
use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Settings_Ids;

/**
 * Api_Factory
 */
class Api_Factory {

	/**
	 * Creates appropriate API service instance based on environment setting.
	 *
	 * Determines if production or testing environment is configured and returns
	 * corresponding API service implementation.
	 *
	 * @return Abstract_Api The API service instance for current environment.
	 */
	public function create_service(): Abstract_Api {
		$is_production = Plugin::get_settings()
								->is_option(
									Settings_Ids::SETTINGS_ID_ENVIRONMENT,
									Settings_Ids::SETTINGS_ID_ENVIRONMENT_PROD
								);

		if ( $is_production ) {
			$api_factory = new Production_Api_Factory();

		} else {
			$api_factory = new Testing_Api_Factory();

		}

		return $api_factory->create_service();
	}
}
