<?php

namespace Inspire_Labs\Empik_Woocommerce\Offer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class Offer_Model {
	/**
	 * The SKU (Stock Keeping Unit) of the offer.
	 *
	 * @var string The unique product identifier.
	 */
	private $sku;

	/**
	 * The unique identifier of the offer.
	 *
	 * @var string The offer ID.
	 */
	private $id;

	/**
	 * The type of ID used for the offer (EAN).
	 *
	 * @var string The ID type identifier.
	 */
	private $id_type;

	/**
	 * Internal description of the offer.
	 *
	 * @var string The internal description text.
	 */
	private $internal_description;

	/**
	 * Additional price information for the offer.
	 *
	 * @var string Additional pricing details.
	 */
	private $price_additional_info;

	/**
	 * Available quantity of the offer.
	 *
	 * @var int The current stock quantity.
	 */
	private $quantity;

	/**
	 * Minimum quantity threshold for alerts.
	 *
	 * @var string The minimum quantity alert level.
	 */
	private $min_quantity_alert;

	/**
	 * Start date of offer availability.
	 *
	 * @var string The availability start date.
	 */
	private $available_start_date;

	/**
	 * End date of offer availability.
	 *
	 * @var string The availability end date.
	 */
	private $available_end_date;

	/**
	 * Logistic class classification.
	 *
	 * @var string The logistic class identifier.
	 */
	private $logistic_class;

	/**
	 * Update or delete status flag.
	 *
	 * @var string The update/delete status.
	 */
	private $update_delete;

	/**
	 * Start date of the discount period.
	 *
	 * @var string The discount start date.
	 */
	private $discount_start_date;

	/**
	 * End date of the discount period.
	 *
	 * @var string The discount end date.
	 */
	private $discount_end_date;

	/**
	 * Regular price of the offer.
	 *
	 * @var string The regular price amount.
	 */
	private $price;

	/**
	 * Discounted price of the offer.
	 *
	 * @var string The discounted price amount.
	 */
	private $discount_price;

	/**
	 * Array of discount range information.
	 *
	 * @var array The discount ranges data.
	 */
	private $discount_ranges;

	/**
	 * Array of price range information.
	 *
	 * @var array The price ranges data.
	 */
	private $price_ranges;

	/**
	 * Channel-specific discount start dates.
	 *
	 * @var array The discount start dates per channel.
	 */
	private $discount_start_date_channel;

	/**
	 * Channel-specific discount end dates.
	 *
	 * @var array The discount end dates per channel.
	 */
	private $discount_end_date_channel;

	/**
	 * Channel-specific prices.
	 *
	 * @var array The prices per channel.
	 */
	private $price_channel;

	/**
	 * Channel-specific discount prices.
	 *
	 * @var array The discount prices per channel.
	 */
	private $discount_price_channel;

	/**
	 * Channel-specific discount ranges.
	 *
	 * @var array The discount ranges per channel.
	 */
	private $discount_ranges_channel;

	/**
	 * Channel-specific price ranges.
	 *
	 * @var array The price ranges per channel.
	 */
	private $prices_ranges_channel;

	/**
	 * Time to ship the offer.
	 *
	 * @var mixed The leadtime to ship value.
	 */
	private $leadtime_to_ship;

	/**
	 * Current state of the product.
	 *
	 * @var string The product state identifier.
	 */
	private $product_state;

	/**
	 * @return string
	 */
	public function get_sku(): string {
		return $this->sku;
	}

	/**
	 * @param string $sku
	 */
	public function set_sku( string $sku ) {
		$this->sku = $sku;
	}

	/**
	 * @return string
	 */
	public function get_id(): string {
		return $this->id;
	}

	/**
	 * @param string $id
	 */
	public function set_id( string $id ) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function get_internal_description(): string {
		return $this->internal_description;
	}

	/**
	 * @param string $internal_description
	 */
	public function set_internal_description( string $internal_description ) {
		$this->internal_description = $internal_description;
	}

	/**
	 * @return string
	 */
	public function get_price_additional_info(): string {
		return $this->price_additional_info;
	}

	/**
	 * @param string $price_additional_info
	 */
	public function set_price_additional_info( string $price_additional_info ) {
		$this->price_additional_info = $price_additional_info;
	}

	/**
	 * @return string
	 */
	public function get_quantity(): string {
		return $this->quantity;
	}

	/**
	 * @param string $quantity
	 */
	public function set_quantity( string $quantity ) {
		$this->quantity = $quantity;
	}

	/**
	 * @return string
	 */
	public function get_min_quantity_alert(): string {
		return $this->min_quantity_alert;
	}

	/**
	 * @param string $min_quantity_alert
	 */
	public function set_min_quantity_alert( string $min_quantity_alert ) {
		$this->min_quantity_alert = $min_quantity_alert;
	}


	/**
	 * @return string
	 */
	public function get_available_start_date(): string {
		return $this->available_start_date;
	}

	/**
	 * @param string $available_start_date
	 */
	public function set_available_start_date( string $available_start_date ) {
		$this->available_start_date = $available_start_date;
	}

	/**
	 * @return string
	 */
	public function get_available_end_date(): string {
		return $this->available_end_date;
	}

	/**
	 * @param string $available_end_date
	 */
	public function set_available_end_date( string $available_end_date ) {
		$this->available_end_date = $available_end_date;
	}

	/**
	 * @return string
	 */
	public function get_logistic_class(): string {
		return $this->logistic_class;
	}

	/**
	 * @param string $logistic_class
	 */
	public function set_logistic_class( string $logistic_class ) {
		$this->logistic_class = $logistic_class;
	}

	/**
	 * @return string
	 */
	public function get_update_delete(): string {
		return isset( $this->update_delete ) ? $this->update_delete : '';
	}

	/**
	 * @param string $update_delete
	 */
	public function set_update_delete( string $update_delete ) {
		$this->update_delete = $update_delete;
	}

	/**
	 * @return string
	 */
	public function get_discount_start_date(): string {
		return $this->discount_start_date ? $this->discount_start_date : '';
	}

	/**
	 * @param string $discount_start_date
	 */
	public function set_discount_start_date( string $discount_start_date ) {
		$this->discount_start_date = $discount_start_date;
	}

	/**
	 * @return string
	 */
	public function get_discount_end_date(): string {
		return $this->discount_end_date ? $this->discount_end_date : '';
	}

	/**
	 * @param string $discount_end_date
	 */
	public function set_discount_end_date( string $discount_end_date ) {
		$this->discount_end_date = $discount_end_date;
	}

	/**
	 * @return array
	 */
	public function get_discount_ranges(): array {
		return $this->discount_ranges;
	}

	/**
	 * @param array $discount_ranges
	 */
	public function set_discount_ranges( array $discount_ranges ) {
		$this->discount_ranges = $discount_ranges;
	}

	/**
	 * @return array
	 */
	public function get_price_ranges(): array {
		return $this->price_ranges;
	}

	/**
	 * @param array $price_ranges
	 */
	public function set_price_ranges( array $price_ranges ) {
		$this->price_ranges = $price_ranges;
	}

	/**
	 * @return array
	 */
	public function get_discount_start_date_channel(): array {
		return $this->discount_start_date_channel;
	}

	/**
	 * @param array $discount_start_date_channel
	 */
	public function set_discount_start_date_channel( array $discount_start_date_channel ) {
		$this->discount_start_date_channel = $discount_start_date_channel;
	}

	/**
	 * @return array
	 */
	public function get_discount_end_date_channel(): array {
		return $this->discount_end_date_channel;
	}

	/**
	 * @param array $discount_end_date_channel
	 */
	public function set_discount_end_date_channel( array $discount_end_date_channel ) {
		$this->discount_end_date_channel = $discount_end_date_channel;
	}

	/**
	 * @return array
	 */
	public function get_price_channel(): array {
		return $this->price_channel;
	}

	/**
	 * @param array $price_channel
	 */
	public function set_price_channel( array $price_channel ) {
		$this->price_channel = $price_channel;
	}

	/**
	 * @return array
	 */
	public function get_discount_price_channel(): array {
		return $this->discount_price_channel;
	}

	/**
	 * @param array $discount_price_channel
	 */
	public function set_discount_price_channel( array $discount_price_channel ) {
		$this->discount_price_channel = $discount_price_channel;
	}

	/**
	 * @return array
	 */
	public function get_discount_ranges_channel(): array {
		return $this->discount_ranges_channel;
	}

	/**
	 * @param array $discount_ranges_channel
	 */
	public function set_discount_ranges_channel( array $discount_ranges_channel ) {
		$this->discount_ranges_channel = $discount_ranges_channel;
	}

	/**
	 * @return array
	 */
	public function get_prices_ranges_channel(): array {
		return $this->prices_ranges_channel;
	}

	/**
	 * @param array $prices_ranges_channel
	 */
	public function set_prices_ranges_channel( array $prices_ranges_channel ) {
		$this->prices_ranges_channel = $prices_ranges_channel;
	}

	/**
	 * @return mixed
	 */
	public function get_leadtime_to_ship() {
		return $this->leadtime_to_ship;
	}

	/**
	 * @param mixed $leadtime_to_ship
	 */
	public function set_leadtime_to_ship( $leadtime_to_ship ) {
		$this->leadtime_to_ship = $leadtime_to_ship;
	}

	/**
	 * @return string
	 */
	public function get_id_type(): string {
		return $this->id_type;
	}

	/**
	 * @param string $id_type
	 */
	public function set_id_type( string $id_type ) {
		$this->id_type = $id_type;
	}

	/**
	 * @return string
	 */
	public function get_discount_price(): string {
		return $this->discount_price;
	}

	/**
	 * @param string $discount_price
	 */
	public function set_discount_price( string $discount_price ) {
		$this->discount_price = $discount_price;
	}

	/**
	 * @return string
	 */
	public function get_price(): string {
		return $this->price;
	}

	/**
	 * @param string $price
	 */
	public function set_price( string $price ) {
		$this->price = $price;
	}

	/**
	 * @return string
	 */
	public function get_product_state(): string {
		return $this->product_state;
	}

	/**
	 * @param string $product_state
	 */
	public function set_product_state( string $product_state ) {
		$this->product_state = $product_state;
	}
}
