<?php

namespace Inspire_Labs\Empik_Woocommerce\Order;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Api_Client\Api_Factory;

/**
 * Status
 */
class Status {

	/**
	 * Init
	 */
	public function init(): void {
		add_action(
			'woocommerce_order_status_completed',
			function ( $order_id ) {
				$meta_value = get_post_meta( $order_id, Order_Importer::EMPIK_ORDER_ID_META_KEY, true );

				// HPOS.
				if ( ! $meta_value && 'yes' === get_option( 'woocommerce_custom_orders_table_enabled' ) ) {
					$order = wc_get_order( $order_id );
					if ( $order && ! is_wp_error( $order ) ) {
						$meta_value = $order->get_meta( Order_Importer::EMPIK_ORDER_ID_META_KEY );
					}
				}

				if ( ! empty( $meta_value ) && is_string( $meta_value ) ) {
					$api_factory = new Api_Factory();
					$api_factory->create_service()->or_24_put_order_ship_confirmation( $meta_value );
				}
			},
			1
		);
	}
}
