<?php

namespace Inspire_Labs\Empik_Woocommerce\Wp_Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use Inspire_Labs\Empik_Woocommerce\Plugin;
use Inspire_Labs\Empik_Woocommerce\Wp_Admin\Abstract_Ajax;
use WC_Product;

class Products_List_Offers_import_Column extends Abstract_Ajax {

	public function init() {
		parent::init();
		add_filter( 'manage_edit-product_columns', [ $this, 'register_column' ], 20 );
		add_action( 'manage_product_posts_custom_column', [ $this, 'output_cell' ], 2 );
	}

	public function ajax_callback() {

		if ( ! wp_doing_ajax() || ! isset( $_POST[ $this->get_ajax_post_data_field_name() ] ) ) {
			return;
		}

		$value      = 'true' === sanitize_text_field( $_POST[ $this->get_ajax_post_data_field_name() ]['value'] );
		$product_id = (int) ( $_POST[ $this->get_ajax_post_data_field_name() ]['product_id'] );
		update_post_meta( $product_id, $this->get_export_offer_meta_id(), $value );

		if ( $value ) {
			$this->remove_waiting_to_delist_flag( $product_id );
		} else {
			$this->add_waiting_to_delist_flag( $product_id );
		}

		exit;
	}

	/**
	 * @param int $product_id
	 */
	private function add_waiting_to_delist_flag( int $product_id ) {
		update_post_meta( $product_id, $this->get_delist_offer_meta_id(), true );
	}

	/**
	 * @param int $product_id
	 */
	public function remove_waiting_to_delist_flag( int $product_id ) {
		update_post_meta( $product_id, $this->get_delist_offer_meta_id(), false );
	}

	protected function get_context_phrase(): string {
		return 'select_offers_to_export';
	}

	/**
	 * @param array $columns
	 *
	 * @return array
	 */
	public function register_column( array $columns ): array {
        $columns[ $this->get_column_id() ] = esc_html__( 'Export offer to Empik?', 'empik-for-woocommerce' )
            . '<div>
                <a href="#" class="empik-export-bulk-offer" data-type="offer" data-id="1" data-active="">'
            . esc_html__( 'All', 'empik-for-woocommerce' ) .
            '</a><br>'
            . '<a href="#" class="empik-export-bulk-offer" data-type="offer" data-id="" data-active="">'
            . esc_html__( 'Nothing', 'empik-for-woocommerce' ) .
            '</a></div>';

        return $columns;
    }

	/**
	 * @param string $column
	 */
	public function output_cell( string $column ) {
		global $post;

		if ( $column === $this->get_column_id() ) {
			$product = wc_get_product( $post->ID );
			$weight  = $product->get_weight();
			echo wp_kses(
				$this->format_field( $this->get_field_name(), $product
				),
				[
					'input' => [
						'type'    => [],
						'name'    => [],
						'id'      => [],
						'class'   => [],
						'data-id' => [],
						'checked' => []
					]
				] );
		}
	}

	/**
	 * @return string
	 */
	private function get_column_id(): string {
		return $this->get_module_id() . '_column';
	}

	/**
	 * @return string
	 */
	public function get_field_name(): string {
		return $this->get_module_id();
	}

	/**
	 * @return string
	 */
	public function get_export_offer_meta_id(): string {
		return $this->get_module_id();
	}

	/**
	 * @return string
	 */
	public function get_delist_offer_meta_id(): string {
		return $this->get_module_id() . '_delist';
	}

	/**
	 * @return string
	 */
	public function get_meta_value_true(): string {
		return '1';
	}

	/**
	 * @return string
	 */
	private function get_module_id(): string {
		return Plugin::APP_PREFIX . '_' . $this->get_context_phrase();
	}

	/**
	 * @return string
	 */
	private function get_ajax_post_data_field_name(): string {
		return 'import_offer';
	}


	/**
	 * @param int $product_id
	 *
	 * @return bool
	 */
	private function is_product_checked( int $product_id ): bool {
		$val = get_post_meta( $product_id, $this->get_export_offer_meta_id() );


		if ( is_array( $val ) && ! empty( $val ) ) {
			return (bool) $val[0];
		}

		return false;
	}

	/**
	 * @param string $name
	 * @param WC_Product $product
	 *
	 * @return string
	 */
	private function format_field( string $name, WC_Product $product ): string {
		$id         = $name . '_' . $product->get_id();
		$product_id = $product->get_id();
		$checked    = $this->is_product_checked( $product_id )
			? 'checked '
			: '';

		return "<input " . esc_attr($checked) . " type=\"checkbox\" name=" . esc_attr($name) . " id=". esc_attr($id). " class=". esc_attr($name) . " data-id=". esc_attr($product_id) . ">";
	}
}
