<?php

namespace EmpikWoocommerceVendor\WPDesk\Helper\Integration;

use EmpikWoocommerceVendor\WPDesk\Helper\Page\SettingsPage;
use EmpikWoocommerceVendor\WPDesk\PluginBuilder\Plugin\Hookable;
use EmpikWoocommerceVendor\WPDesk\PluginBuilder\Plugin\HookableCollection;
use EmpikWoocommerceVendor\WPDesk\PluginBuilder\Plugin\HookableParent;
/**
 * Integrates WP Desk main settings page with WordPress
 *
 * @package WPDesk\Helper
 */
class SettingsIntegration implements \EmpikWoocommerceVendor\WPDesk\PluginBuilder\Plugin\Hookable, \EmpikWoocommerceVendor\WPDesk\PluginBuilder\Plugin\HookableCollection
{
    use HookableParent;
    /** @var SettingsPage */
    private $settings_page;
    public function __construct(\EmpikWoocommerceVendor\WPDesk\Helper\Page\SettingsPage $settingsPage)
    {
        $this->add_hookable($settingsPage);
    }
    /**
     * @return void
     */
    public function hooks()
    {
        $this->hooks_on_hookable_objects();
    }
}
