<?php
$group_color = 'Typo & Color';

vc_map( array(
	'base'          => 'penci_web_stories',
	'icon'          => get_template_directory_uri() . '/images/vc-icon.png',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'html_template' => get_template_directory() . '/inc/js_composer/shortcodes/web_stories/frontend.php',
	'weight'        => 700,
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Web Stories', 'soledad' ),
	'description'   => __( 'Show Google Web Stories', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge( array(
		array(
			'type'             => 'textfield',
			'param_name'       => 'heading_ptitle_1',
			'heading'          => esc_html__( 'Web Stories Query', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Query Type', 'soledad' ),
			'param_name'  => 'query_type',
			'value'       => array(
				esc_html__( 'All Stories', 'soledad' )    => 'all',
				esc_html__( 'Custom Stories', 'soledad' ) => 'custom',
			),
			'save_always' => true,
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order By', 'soledad' ),
			'param_name'  => 'orderby',
			'value'       => array(
				''                                            => '',
				esc_html__( 'Date', 'soledad' )               => 'date',
				esc_html__( 'ID', 'soledad' )                 => 'id',
				esc_html__( 'Author', 'soledad' )             => 'author',
				esc_html__( 'Title', 'soledad' )              => 'title',
				esc_html__( 'Last modified date', 'soledad' ) => 'modified',
				esc_html__( 'Random order', 'soledad' )       => 'rand',
			),
			'save_always' => true,
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'soledad' ),
			'param_name'  => 'order',
			'value'       => array(
				''                              => '',
				esc_html__( 'DESC', 'soledad' ) => 'desc',
				esc_html__( 'ASC', 'soledad' )  => 'asc',
			),
			'save_always' => true,
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Stories Categories IDs', 'soledad' ),
			'param_name' => 'story_cat',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Stories Tags IDs', 'soledad' ),
			'param_name' => 'story_tag',
		),
		array(
			'type'       => 'textfield',
			'heading'    => __( 'Stories Posts IDs', 'soledad' ),
			'param_name' => 'story_ids',
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Number of Stories', 'soledad' ),
			'param_name' => 'number',
			'value'      => 12,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Offset', 'soledad' ),
			'param_name' => 'offset',
		),
		array(
			'type'             => 'textfield',
			'param_name'       => 'heading_ptitle_2',
			'heading'          => esc_html__( 'Layout Settings', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Layout Type', 'soledad' ),
			'param_name'  => 'layout',
			'value'       => array(
				esc_html__( 'One Row', 'soledad' ) => 'onerow',
				esc_html__( 'Grid', 'soledad' )    => 'grid',
				esc_html__( 'Slider', 'soledad' )  => 'slider',
			),
			'save_always' => true,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Number of Columns', 'soledad' ),
			'param_name' => 'columns',
			'value'      => 12,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Custom Item Width', 'soledad' ),
			'param_name' => 'iwidth',
			'value'      => 100,
			'dependency' => array( 'element' => 'layout', 'value' => 'onerow' ),
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Columns Gap (px)', 'soledad' ),
			'param_name' => 'gap',
		),
		array(
			'type'        => 'penci_switch',
			'heading'     => __( 'Show Story Title', 'soledad' ),
			'param_name'  => 'showtitle',
			'value'       => 'yes',
			'save_always' => true,
		),
		array(
			'type'        => 'penci_switch',
			'heading'     => __( 'Show Next/Prev Buttons', 'soledad' ),
			'param_name'  => 'nextprev',
			'value'       => 'yes',
			'save_always' => true,
		),
		array(
			'type'        => 'penci_switch',
			'heading'     => __( 'Show Current Stories Number', 'soledad' ),
			'param_name'  => 'pos',
			'value'       => 'yes',
			'save_always' => true,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Custom Images Border Radius (px)', 'soledad' ),
			'param_name' => 'iboradius',
			'value'      => '',
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Ajax Loading Style', 'soledad' ),
			'param_name'  => 'ajax_loading_style',
			'value'       => [
				'Follow Customize' => 'df',
				'Style 1'          => 's9',
				'Style 2'          => 's2',
				'Style 3'          => 's3',
				'Style 4'          => 's4',
				'Style 5'          => 's5',
				'Style 6'          => 's6',
				'Style 7'          => 's1',
			],
			'save_always' => true,
		),

		array(
			'type'             => 'textfield',
			'param_name'       => 'heading_ptitle_3',
			'heading'          => esc_html__( 'Web Stories Style', 'soledad' ),
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Stories Borders Color', 'soledad' ),
			'param_name' => 'bd_color',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Stories Seen Borders Color', 'soledad' ),
			'param_name' => 'bd_scolor',
			'group'      => $group_color,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Stories Border Width (px)', 'soledad' ),
			'param_name' => 'bd_w',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Stories Inner Borders Color', 'soledad' ),
			'param_name' => 'bd_innercolor',
			'group'      => $group_color,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Stories Inner Border Width (px)', 'soledad' ),
			'param_name' => 'bd_iw',
			'group'      => $group_color,
		),
		array(
			'type'       => 'colorpicker',
			'heading'    => __( 'Stories Title Color', 'soledad' ),
			'param_name' => 'color_title',
			'group'      => $group_color,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Stories Title Font Size (px)', 'soledad' ),
			'param_name' => 'title_fsize',
			'group'      => $group_color,
		),
		array(
			'type'       => 'penci_only_number',
			'heading'    => __( 'Stories Title Font Size (px)', 'soledad' ),
			'param_name' => 'title_fsize',
			'group'      => $group_color,
		),
		array(
			'type'       => 'penci_switch',
			'heading'    => __( 'Custom Font Family for Story Title', 'soledad' ),
			'param_name' => 'use_ptitle_typo',
			'default'    => 'no',
			'std'        => 'no',
			'group'      => $group_color,
		),
		array(
			'type'       => 'google_fonts',
			'group'      => $group_color,
			'param_name' => 'ptitle_typo',
			'value'      => '',
			'dependency' => array( 'element' => 'use_ptitle_typo', 'value' => 'yes' ),
		),
	), Penci_Vc_Params_Helper::heading_block_params(), Penci_Vc_Params_Helper::params_heading_typo_color(), Penci_Vc_Params_Helper::extra_params() )
) );
