<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.

$routes->match(['get', 'post'], 'login', 'UserController::login', ["filter" => "noauth"]);
// Admin routes
// $routes->group("admin", static function ($routes) {
//     $routes->get("/", "admin\AuthController::index",['filter' => 'adminauth']);
//     $routes->get("package", "AdminController::package");
$routes->group("admin", ["filter" => "auth"], function ($routes) {
    $routes->get("/", "AdminController::index");
    $routes->get("package", "AdminController::package");
    $routes->match(['get', 'post'],"addPackage", "AdminController::addPackage");
    $routes->get("editPackage/(:num)", "AdminController::editPackage/$1");
    $routes->post("updatePackage", "AdminController::updatePackage");
    $routes->post("storePackage", "AdminController::storePackage");
    $routes->get("appointment", "AdminController::appointment");
    $routes->get("editAppointment/(:num)", "AdminController::editAppointment/$1");
    $routes->post("updateAppointment", "AdminController::updateAppointment");

    $routes->get("categories", "AdminController::categories");
    $routes->get("categories/(:num)", "AdminController::categories/$1");
    $routes->post("addCategories", "AdminController::addCategories");
    $routes->post("updateCategories", "AdminController::updateCategories");
    
    $routes->get("posts", "AdminController::posts");
    $routes->get("post/(:num)", "AdminController::posts/$1");
    $routes->post("addPost", "AdminController::addPost");
    $routes->post("updatePost", "AdminController::updatePost");

    $routes->get("labtest", "AdminController::labtest");
    $routes->get("labtest/(:num)", "AdminController::labtest/$1");
    $routes->get("labtest/delete/(:num)", "AdminController::deleteTest/$1");
    $routes->post("addTest", "AdminController::addTest");
    $routes->post("updateTest", "AdminController::updateTest");

    $routes->get("labtest/extra/(:any)", "AdminController::extra/$1");
    $routes->get("labtest/extra/(:num)/(:num)", "AdminController::extra/$1/$1");
    $routes->post("addExtra", "AdminController::addExtra");
});


// Editor routes
$routes->group("editor", ["filter" => "auth"], function ($routes) {
    $routes->get("/", "EditorController::index");
});
$routes->get('logout', 'UserController::logout');


$routes->get('/', 'HomeController::index');
$routes->get('/contactus', 'HomeController::contactus');
$routes->get('/aboutus', 'HomeController::aboutus');
$routes->get('/our-packages', 'HomeController::packages');
$routes->get('/our-gallery', 'HomeController::gallery');
//$routes->get('/our-services', 'HomeController::services');
$routes->get('/dr-pawan-zutshi', 'HomeController::docter');
// $routes->get('/zutshi-lab', 'HomeController::zutshilab');
$routes->get('/zutshi-home', 'HomeController::zutshihome');
$routes->get('/blogs', 'BlogController::index');
$routes->get('/blog/(:any)', 'BlogController::blog/$1');

$routes->get('/zutshi-lab', 'LabtestController::index');
$routes->get('/zutshi-lab/test/(:any)', 'LabtestController::test/$1');

$routes->get('/our-services', 'ServiceController::index');
$routes->get('/service/(:any)', 'ServiceController::service/$1');

$routes->match(['get', 'post'],'/appointment', 'HomeController::appointment');

$routes->get('/consultation/(:any)', 'HomeController::consultation/$1');

$routes->get('/cart', 'CartController::index');
$routes->get('/cart/add/(:any)', 'CartController::addItem/$1');
$routes->get('/cart/remove/(:any)', 'CartController::removeItem/$1');
$routes->get('/cart/checkout', 'CartController::checkout/$1');
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
