<?php

namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\PackageModel;
use App\Models\AppointmentModel;
use App\Models\CategoriesModel;
use App\Models\PostModel;
use App\Models\LabtestModel;
use App\Models\LabtestextraModel;
class AdminController extends BaseController
{
    public function __construct()
    {
        if (session()->get('role') != "admin") {
            echo 'Access denied';
            exit;
        }
    }
    public function index()
    {    
        $package = new PackageModel();
        $appointment = new AppointmentModel();
        $post = new PostModel();
        $data = [];
        $data['packages_count'] = $package->countAll();
        $data['appointment_count'] = $appointment->countAll();
        $data['pending_appointment_count'] = $post->where('status','P')->countAll();
        $data['post_count'] = $post->countAll();
        return view("admin/dashboard",$data);
    }

    public function package(){
        $data = [];
        $package = new PackageModel();
        $data['packages'] = $package->orderBy('id', 'DESC')->findAll();
        return view("admin/package/index",$data);
    }

    public function addPackage(){
        $data = [];
        return view("admin/package/add",$data);
    }

    public function editPackage($id = null){
        $data = [];
        $package = new PackageModel();
        $data['package'] = $package->where('id',$id)->first();
        return view("admin/package/edit",$data);
    }
    
    
    public function deletePackage($id=0){
        ## Check record
        $package = new PackageModel();
        $res = $package->where('id', $id)->first();
        if($res){
           ## Delete record
           if($package->delete($id)){
            $flashdata = ['status' => 'success', 'title'  => 'Great!', 'msg' => 'Package successfully deleted!'];
           }else{
            $flashdata = ['status' => 'danger', 'title'  => 'Oops!', 'msg' => 'Something went wrong! Try later'];
           }
           $this->session->setFlashdata($flashdata);
        }else{
            $flashdata = ['status' => 'warning', 'title'  => 'Oops!', 'msg' => 'Record not found!'];
            $this->session->setFlashdata($flashdata);
        }
  
        return redirect()->route('backend/book');
  
    }

    public function storePackage(){
        $package = new PackageModel();
        $data = [
            'title' => $this->request->getVar('title'),
            'desc'  => $this->request->getVar('desc'),
            'price'  => $this->request->getVar('price'),
            'sprice'  => $this->request->getVar('sprice'),
            'featured'  => $this->request->getVar('featured') == 'on' ? 'Y' : 'N',
            'status'  => $this->request->getVar('status')
        ];
        $package->insert($data);
        return $this->response->redirect(site_url('/admin/package'));
    }
    public function updatePackage(){
        $package = new PackageModel();
        $id = $this->request->getVar('id');
        $data = [
            'title' => $this->request->getVar('title'),
            'desc'  => $this->request->getVar('desc'),
            'price'  => $this->request->getVar('price'),
            'sprice'  => $this->request->getVar('sprice'),
            'featured'  => $this->request->getVar('featured') == 'on' ? 'Y' : 'N',
            'status'  => $this->request->getVar('status')
        ];
        $package->update($id, $data);
        return $this->response->redirect(site_url('/admin/package'));
    }

    public function appointment(){
        $data = [];
        $appointment = new AppointmentModel();
        $data['appointment'] = $appointment->orderBy('id', 'DESC')->findAll();
        return view("admin/appointment/index",$data);
    }

    public function editAppointment($id = null){
        $data = [];
        $appointment = new AppointmentModel();
        $data['appointment'] = $appointment->where('id',$id)->first();
        return view("admin/appointment/edit",$data);
    }

    public function updateAppointment(){
        $appointment = new AppointmentModel();
        $id = $this->request->getVar('id');
        if ($this->request->getMethod() == 'post') {
			$data = [
				'service' => $this->request->getVar('service', FILTER_SANITIZE_STRING),
				'patient' => $this->request->getVar('patient', FILTER_SANITIZE_STRING),
                'clinic_name' => $this->request->getVar('clinic_name', FILTER_SANITIZE_STRING),
                'appointment_date' => $this->request->getVar('appointment_date', FILTER_SANITIZE_STRING),
                'appointment_time' => $this->request->getVar('appointment_time', FILTER_SANITIZE_STRING),
                'name' => $this->request->getVar('name', FILTER_SANITIZE_STRING),
                'email' => $this->request->getVar('email', FILTER_SANITIZE_STRING),
                'phone' => $this->request->getVar('phone', FILTER_SANITIZE_STRING),
				'msg' => $this->request->getVar('msg', FILTER_SANITIZE_STRING),
                'status' => $this->request->getVar('status', FILTER_SANITIZE_STRING),
			];
			if ($appointment->update($id, $data)) {
                sendMail(CONFIRM_APPOINTMENT_EMAIL_TEMPLATE,$data);
                session()->setFlashdata('msg', 'Patient Appointment Successfully Updated.');
                session()->setFlashdata('alert-class', 'alert-success');
			} else {
                session()->setFlashdata('msg', 'Something went wrong. Please try again');
                session()->setFlashdata('alert-class', 'alert-error');
               
			}
		}
        return $this->response->redirect(site_url('/admin/appointment'));
    }

    public function categories($id = null){
        $data = [];
        $categories = new CategoriesModel();
        if($id){
            $data['cat'] = $categories->where('id', $id)->first();
            $data['action'] = 'update';
        }else{
            $data['action'] = 'add';
        }
        $data['categories'] = $categories->orderBy('id', 'DESC')->findAll();
        return view("admin/categories/add-edit-view",$data);
        //return view("admin/categories/index",$data);
    }
    public function addCategories(){
        $data = [];
        $categories = new CategoriesModel();
    if ($this->request->getMethod() == 'post') {
        $data = [
            'name' => $this->request->getVar('name'),
            'description'  => $this->request->getVar('description'),
            'status'  => $this->request->getVar('status')
        ];
        if ($categories->insert($data)) {
            session()->setFlashdata('msg', 'Category successfully added.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/categories'));
    }
    public function updateCategories(){
        $data = [];
        $categories = new CategoriesModel();
        $id = $this->request->getVar('id');
    if ($this->request->getMethod() == 'post') {
        $data = [
            'name' => $this->request->getVar('name'),
            'description'  => $this->request->getVar('description'),
            'status'  => $this->request->getVar('status')
        ];
        if ($categories->update($id, $data)) {
            session()->setFlashdata('msg', 'Category successfully updated.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/categories'));
    }
    

    public function labtest($id = null){
        $data = [];
        $labtest = new LabtestModel();
        if($id){
            $data['row'] = $labtest->where('id', $id)->first();
            $data['action'] = 'update';
        }else{
            $data['action'] = 'add';
        }
        $data['data'] = $labtest->orderBy('id', 'DESC')->findAll();
        //print_r($data['data']); die;
        return view("admin/labtest/add-edit-view",$data);
    }

    public function addTest(){
        $data = [];
        $labtest = new LabtestModel();
    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        $img = $this->request->getFile('banner');
        $randomName = '';
        if ($img->isValid() && ! $img->hasMoved()) {
            $randomName = $img->getRandomName();
            $img->move('uploads',$randomName);
            $data['banner'] = $randomName;
        }else{
            unset($data['banner']);
        }
        $data['slug'] = slugify($this->request->getVar('title'));
        if ($labtest->insert($data)) {
            session()->setFlashdata('msg', 'Labtest successfully added.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/labtest'));
    }
    public function updateTest(){
        $data = [];
        $labtest = new LabtestModel();
        $id = $this->request->getVar('id');
    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        $img = $this->request->getFile('banner');
        $randomName = $data['old_banner'];
            if ($img->isValid() && ! $img->hasMoved()) {
                $randomName = $img->getRandomName();
                $img->move('uploads',$randomName);
                $data['banner'] = $randomName;
                if($data['old_banner']){ 
                    unlink('uploads/'.$data['old_banner']);
                    unset($data['old_banner']);
                }
            }else{
                unset($data['old_banner']);
                unset($data['banner']);
            }
        unset($data['id']);
        $data['slug'] = slugify($this->request->getVar('title'));

        if ($labtest->update($id, $data)) {
            session()->setFlashdata('msg', 'Lab test successfully updated.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/labtest'));
    }
    
    public function deleteTest($id=0){
        ## Check record
        $labtest = new LabtestModel();
        $labtestextra = new LabtestextraModel();
        $res = $labtest->where('id', $id)->first();
        if($res){
           ## Delete record
           if($labtest->delete($id)){
               $labtestextra->where('testId', $id)->delete();
               session()->setFlashdata('msg', 'Lab test successfully deleted.');
               session()->setFlashdata('alert-class', 'alert-success');
           }else{
               session()->setFlashdata('msg', 'Something went wrong! Try later');
               session()->setFlashdata('alert-class', 'alert-failure');
           }
        }else{
            session()->setFlashdata('msg', 'Lab test not found !');
            session()->setFlashdata('alert-class', 'alert-warning');
        }
  
        return redirect()->route('admin/labtest');
  
    }

    public function extra($id = null)
    {   
        $arr = explode('_',$id);
        if(count($arr) > 1){
            $testId = $arr['0'];
            $id = $arr['1'];
        }else{
            $testId = $id;
            $id = '';
        }
        $data = [];
        $labtestextra = new LabtestextraModel();
        $labtest = new LabtestModel();
        if(!empty($testId) && ($id == '')){
            $data['test'] = $labtest->where('id', $testId)->first();
            $data['action'] = 'add';
        }else{
            $data['action'] = 'update';
            $data['row'] = $labtestextra->where('id', $id)->first();
            $data['test'] = $labtest->where('id', $data['row']['testId'] )->first();
        }
        $data['data'] = $labtestextra->where('testId', $testId)->findAll();
        return view('admin/labtest/add-edit-labtestextra',$data);
    }

    public function addExtra(){
        $data = [];
        $labtestextra = new LabtestextraModel();
    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        
        if ($labtestextra->insert($data)) {
            session()->setFlashdata('msg', 'Labtest extra details successfully added.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/labtest/extra/'.$data['testId']));
    }

    public function updateExtra(){
        $data = [];
        $labtest = new LabtestModel();
        $id = $this->request->getVar('id');
    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        $img = $this->request->getFile('banner');
        $randomName = $data['old_banner'];
            if ($img->isValid() && ! $img->hasMoved()) {
                $randomName = $img->getRandomName();
                $img->move('uploads',$randomName);
                $data['banner'] = $randomName;
                if($data['old_banner']){ 
                    unlink('uploads/'.$data['old_banner']);
                    unset($data['old_banner']);
                }else{
                    unset($data['banner']);
                }
            }else{
                unset($data['old_banner']);unset($data['banner']);
            }
        unset($data['id']);
        $data['slug'] = slugify($this->request->getVar('title'));

        if ($labtest->update($id, $data)) {
            session()->setFlashdata('msg', 'Lab test successfully updated.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/labtest'));
    }

    

    
    public function posts($id = null){
        $data = [];
        $post = new PostModel();
        $categories = new CategoriesModel();
        if($id){
            $data['post'] = $post->where('id', $id)->first();
            $data['action'] = 'update';
        }else{
            $data['action'] = 'add';
        }
        $data['posts'] = $post->orderBy('id', 'DESC')->findAll();
        $data['categories'] = $categories->orderBy('id', 'DESC')->findAll();
        return view("admin/posts/add-edit-view",$data);
    }

    public function addPost(){
        $data = [];
        $categories = new CategoriesModel();
        $post = new PostModel();
    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        $img = $this->request->getFile('banner');
        $randomName = '';
        if ($img->isValid() && ! $img->hasMoved()) {
            $randomName = $img->getRandomName();
            $img->move('uploads',$randomName);
            $data['banner'] = $randomName;
        }

        $data['title'] = $this->request->getVar('title');
        $data['category_id'] = $this->request->getVar('category_id');
        $data['slug'] = slugify($this->request->getVar('title'));
        $data['short_desc'] = $this->request->getVar('short_desc');
        $data['content'] = $this->request->getVar('content');
        $data['status'] = $this->request->getVar('status');

        if ($post->insert($data)) {
            session()->setFlashdata('msg', 'Post successfully added.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/posts'));
    }

    public function updatePost(){

        $data = [];
        $categories = new CategoriesModel();
        $post = new PostModel();
        $id = $this->request->getVar('id');

    if ($this->request->getMethod() == 'post') {
        $data = $this->request->getPost();
        $img = $this->request->getFile('banner');

            $randomName = $data['old_banner'];
            if ($img->isValid() && ! $img->hasMoved()) {
                $randomName = $img->getRandomName();
                $img->move('uploads',$randomName);
                $data['banner'] = $randomName;
                unlink('uploads/'.$data['old_banner']);
            }
            $data['title'] = $this->request->getVar('title');
            $data['category_id'] = $this->request->getVar('category_id');
            $data['slug'] = slugify($this->request->getVar('title'));
            $data['short_desc'] = $this->request->getVar('short_desc');
            $data['content'] = $this->request->getVar('content');
            $data['status'] = $this->request->getVar('status');
       
        if ($post->update($id, $data)) {
            session()->setFlashdata('msg', 'Post successfully updated.');
            session()->setFlashdata('alert-class', 'alert-success');
        } else {
            session()->setFlashdata('msg', 'Something went wrong. Please try again');
            session()->setFlashdata('alert-class', 'alert-error');
           
        }
    }
        return $this->response->redirect(site_url('/admin/posts'));
    }


        
}