<?php

namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\LabtestModel;

class CartController extends BaseController{
    
    public $labtest;
    public $session;
    public function __construct()
    {
        $this->session = session();
        $this->labtest = new LabtestModel();
    }
    
    function index(){
        $data = array();
        $data['meta_title'] = 'Cart | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre';
        // Retrieve cart data from the session
        $data['cart'] = $this->cart->contents();
        $data['total'] = $this->cart->totalItems();
        $data['count'] = count($this->cart->contents());
        // Load the cart view
        return view('frontend/cart/index',$data);
    }
    
    function addItem($testId = null){
        $data = $this->labtest->where('id',$testId)->first();
        // Insert an array of value
        $this->cart->insert(array(
  'id'      => 'sku_'.$data['id'],
  'qty'     => 1,
  'price'   => $data['sprice'],
  'name'    => $data['title'],
  'options' => array('Price' => $data['price'], 'tests' => $data['short_desc'])
));


//  $this->cart->insert(array(
//   'id'      => 'sku_'.$data['id'],
//   'qty'     => 1,
//   'price'   => $data['sprice'],
//   'name'    => $data['title'],
//   'options' => array('Size' => 'L', 'Color' => 'Red')
// ));


return redirect()->to(base_url('cart'));	

    }
    
    function update(){
        $this->cart->update(array(
  'rowid'   => '4166b0e7fc8446e81e16883e9a812db8',
  'id'      => 'sku_1234ABCD',
  'qty'     => 3,
  'price'   => '24.89',
  'name'    => 'T-Shirt',
  'options' => array('Size' => 'L', 'Color' => 'Red')
));
    }
    

    
    
    function updateItemQty(){
        $update = 0;
        
        // Get cart item info
        $rowid = $this->input->get('rowid');
        $qty = $this->input->get('qty');
        
        // Update item in the cart
        if(!empty($rowid) && !empty($qty)){
            $data = array(
                'rowid' => $rowid,
                'qty'   => $qty
            );
            $update = $this->cart->update($data);
        }
        
        // Return response
        echo $update?'ok':'err';
    }
    
    function removeItem($rowid){
        // Remove item from cart
        $remove = $this->cart->remove($rowid);
        
        // Redirect to the cart page
        return redirect()->to(base_url('cart'));
    }
    
    function removeCart($rowid){
        // Remove all item from cart
        $remove = $this->cart->destroy();
        // Redirect to the cart page
        return redirect()->to(base_url('cart'));
    }
    
    function checkout(){
        echo "CHECKOUT !!";
    }
    
}


