<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\Categories;

class CategoriesController extends BaseController
{   

    public $categories;
    public $session;
    public function __construct()
    {
        if (session()->get('role') != "admin") {
            echo 'Access denied';
            exit;
        }
        $this->session = session();
        $this->categories = new CategoriesModel();
    }

    public function index()
    {
        $this->data['page_title'] = "Categories";
        $this->data['page'] =  !empty($this->request->getVar('page')) ? $this->request->getVar('page') : 1;
        $this->data['perPage'] =  5;
        $this->data['total'] =  $this->categories->orderBy('abs((name)) asc')
                                ->countAllResults();
        $this->data['categories'] = $this->categories->orderBy('abs((name)) asc')
                                ->paginate($this->data['perPage']);
        $this->data['total_res'] = is_array($this->data['categories'])? count($this->data['categories']) : 0;
        $this->data['pager'] = $this->categories->pager;
        
        return view('admin/categories/index', $this->data);
    }
    public function category($id="")
    {
        if(empty($id))
        return redirect()->to('Blog/PagenotFound');
        
        $category = $this->category_model->where('id',$id)->first();
        if(!isset($category['id']))
            return redirect()->to('Blog/PagenotFound');
        $this->data['page_title'] = $category['name'];
        $this->data['category'] = $category;
        $this->data['page'] =  !empty($this->request->getVar('page')) ? $this->request->getVar('page') : 1;
        $this->data['perPage'] =  5;
        $this->data['total'] =  $this->post_model
                                ->where('status', 1)
                                ->where('category_id', $id)
                                ->orderBy('abs(unix_timestamp(created_at)) DESC')
                                ->countAllResults();
        $this->data['posts'] = $this->post_model
                                ->where('status', 1)
                                ->where('category_id', $id)
                                ->orderBy('abs(unix_timestamp(created_at)) DESC')
                                ->paginate($this->data['perPage']);
        $this->data['total_res'] = is_array($this->data['posts'])? count($this->data['posts']) : 0;
        $this->data['pager'] = $this->post_model->pager;
        return view('pages/public/category', $this->data);
    }
    public function view($id = ''){
        if(empty($id))
        return redirect()->to('Blog/PagenotFound');
        $post = $this->post_model
                     ->select("posts.*, users.email as author, concat(users.name, ' - ', users.email) as author_full, categories.name as category")
                     ->where("posts.id = '{$id}'")
                     ->join('users',"posts.user_id = users.id", "inner")
                     ->join('categories',"posts.user_id = categories.id", "inner")
                     ->first();
        if(!isset($post['id']))
        return redirect()->to('Blog/PagenotFound');
        $this->data['page_title'] = $post['title'];
        $this->data['post'] = $post;
        return view('pages/public/post', $this->data);
    }
    public function PagenotFound(){
        $this->data['page_title'] = "Page Not Found";
        return view('pages/public/page_not_found', $this->data);
    }
}
