<?php

namespace App\Controllers;
use App\Models\PackageModel;
use App\Models\AppointmentModel;
use App\Models\PostModel;
class HomeController extends BaseController
{  
    public $appointment;
    public $post;
    public $session;
	public function __construct() {
		$this->appointment = new AppointmentModel();
        $this->post = new PostModel();
        $this->session = session();
	}

    public function index()
    {   
        $parser = \Config\Services::parser();
        $data['meta_title'] = 'Zutshi Heart Clinic & Diagnostic Centre - We care of your heart.'; 
        $data['meta_desc'] = 'Welcome to the Zutshi Heart Clinic & Diagnostic Centre, where we specialize in providing exceptional cardiac care using cutting-edge technology and the expertise of our experienced team of cardiologists. Our clinic is dedicated to diagnosing, treating, and managing various heart conditions to ensure optimal cardiovascular health for our patients. From preventive screenings and risk assessments to advanced treatment options, we are committed to delivering personalized care in a compassionate and patient-centered environment. Trust our renowned cardiology experts to guide you on your journey to a healthy heart.'; 
        $data['meta_keywords'] = 'Cardiology clinic, heart care, advanced cardiac treatments, experienced cardiologists, state-of-the-art technology, cardiovascular health, preventive screenings, heart condition management, personalized care, compassionate environment.';
        $data['posts'] = $this->post->findAll(3,0);
        //return $parser->setData($data)->render('frontend/home');
        return view('frontend/home',$data);
    }

    public function contactus()
    {   
        $data['meta_title'] = 'Contact Us | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/contactus',$data);
    }

    public function aboutus()
    {   
        $data['meta_title'] = 'About Us | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/aboutus',$data);
    }

    public function packages()
    {   
        $data['meta_title'] = 'Our Packages | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/packages',$data);
    }

    public function gallery()
    {   
        $data['meta_title'] = 'Our Gallery | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/gallery',$data);
    }

    public function services()
    {   
        $data['meta_title'] = 'Our Services | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/services',$data);
    }

    public function docter()
    {   
        $data['meta_title'] = 'Dr. Pawan Zutshi | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/docter',$data);
    }

    public function zutshilab()
    {   
        $package = new PackageModel();
        $data['packages'] = $package->orderBy('id', 'DESC')->findAll();
        $data['meta_title'] = 'Zutshi Lab | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/zutshilab',$data);
    }

    public function zutshihome()
    {   
        $data['meta_title'] = 'Zutshi Home | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/zutshi-home',$data);
    }

    public function appointment()
    {   
        $data = [
			'meta_title' => 'Appointment | Zutshi Heart Clinic & Diagnostic Centre',
            'meta_desc' => 'Zutshi Heart Clinic & Diagnostic Centre',
			'errors' => NULL,
		];
		if ($this->request->getMethod() == 'post') {
			$newdata = [
                'appointment_code' =>  randomMD5(),
                'type' => $this->request->getVar('type', FILTER_SANITIZE_STRING),
                'clinic_name' => $this->request->getVar('clinic_name', FILTER_SANITIZE_STRING),
				'service' => $this->request->getVar('service', FILTER_SANITIZE_STRING),
				'patient' => $this->request->getVar('patient', FILTER_SANITIZE_STRING),
                'appointment_date' => $this->request->getVar('appointment_date', FILTER_SANITIZE_STRING),
                'appointment_time' => $this->request->getVar('appointment_time', FILTER_SANITIZE_STRING),
                'name' => $this->request->getVar('name', FILTER_SANITIZE_STRING),
                'email' => $this->request->getVar('email', FILTER_SANITIZE_STRING),
                'phone' => $this->request->getVar('phone', FILTER_SANITIZE_STRING),
				'msg' => $this->request->getVar('msg', FILTER_SANITIZE_STRING),
			];
			if ($this->appointment->insert($newdata) === false) {
				$data['errors'] = $this->appointment->errors();	
                session()->setFlashdata('title', 'Oops!');
                session()->setFlashdata('msg', 'Something went wrong. Please try again');
                session()->setFlashdata('alert-class', 'alert-error');
			} else {
                sendMail(BOOK_APPOINTMENT_EMAIL_TEMPLATE,$newdata);
                session()->setFlashdata('title', 'Great!');
                session()->setFlashdata('msg', 'You have successfully make an appoinment. We will respond to you as soon as possible.');
                session()->setFlashdata('alert-class', 'alert-success');
				return redirect()->to(base_url('appointment'));	
			}
		}

        return view('frontend/appointment',$data);
    }
    
    public function consultation($type = null){
        $data['meta_title'] = 'Zutshi Home | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/consultation/'.$type,$data);
    }

}
