<?php

namespace App\Controllers;
use App\Models\PackageModel;
use App\Models\AppointmentModel;
use App\Models\PostModel;
class ServiceController extends BaseController
{  
    public $appointment;
    public $post;
    public $session;
	public function __construct() {
		$this->appointment = new AppointmentModel();
        $this->post = new PostModel();
        $this->session = session();
	}
    public function index()
    {   
        $data['meta_title'] = 'Our Services | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/services',$data);
    }

    public function service($service = null)
    {   
        if($service == 'stress-echocardiogram'){
            $metaTitle = 'Stress Echocardiogram | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'stress-echo';
        }else if($service == 'treadmill-test'){
            $metaTitle = 'Treadmill | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'treadmill';
        }else if($service == 'holter-monitoring'){
            $metaTitle = 'Holter Monitoring | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'holter-monitoring';
        }else if($service == 'dobutamine-stress-echocardiography'){
            $metaTitle = 'Dobutamine Stress Echocardiography | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'dse';
        }else if($service == 'pulmonary-function-test'){
            $metaTitle = 'Pulmonary Function Test | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'pft';
        }else if($service == 'ambulatory-blood-pressure-monitoring'){
            $metaTitle = 'Ambulatory Blood Pressure Monitoring | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'abpm';
        }else if($service == 'ecg'){
            $metaTitle = 'ECG | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'ecg';
        }else if($service == 'echo'){
            $metaTitle = 'ECHO | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'echo';
        }else{
            $metaTitle = 'Our Services | Zutshi Heart Clinic & Diagnostic Centre';
            $metaDesc = 'Zutshi Heart Clinic & Diagnostic Centre';
            $page = 'index';
        }
        $data['meta_title'] = $metaTitle ;
        $data['meta_desc'] =  $metaDesc;
        return view('frontend/services/'.$page,$data);
    }

    public function docter()
    {   
        
        $data['meta_title'] = 'Dr. Pawan Zutshi | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/docter',$data);
    }

    public function zutshilab()
    {   
        $package = new PackageModel();
        $data['packages'] = $package->orderBy('id', 'DESC')->findAll();
        $data['meta_title'] = 'Zutshi Lab | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/zutshilab',$data);
    }

    public function zutshihome()
    {   
        $data['meta_title'] = 'Zutshi Home | Zutshi Heart Clinic & Diagnostic Centre'; 
        $data['meta_desc'] = 'Zutshi Heart Clinic & Diagnostic Centre'; 
        return view('frontend/zutshi-home',$data);
    }

    public function appointment()
    {   
        $data = [
			'meta_title' => 'Appointment | Zutshi Heart Clinic & Diagnostic Centre',
            'meta_desc' => 'Zutshi Heart Clinic & Diagnostic Centre',
			'errors' => NULL,
		];
		if ($this->request->getMethod() == 'post') {
			$newdata = [
                'appointment_code' =>  randomMD5(),
				'service' => $this->request->getVar('service', FILTER_SANITIZE_STRING),
				'patient' => $this->request->getVar('patient', FILTER_SANITIZE_STRING),
                'appointment' => $this->request->getVar('appointment', FILTER_SANITIZE_STRING),
                'name' => $this->request->getVar('name', FILTER_SANITIZE_STRING),
                'email' => $this->request->getVar('email', FILTER_SANITIZE_STRING),
                'phone' => $this->request->getVar('phone', FILTER_SANITIZE_STRING),
				'msg' => $this->request->getVar('msg', FILTER_SANITIZE_STRING),
			];
            
			if ($this->appointment->insert($newdata) === false) {
				$data['errors'] = $this->appointment->errors();	
                session()->setFlashdata('msg', 'Something went wrong. Please try again');
                session()->setFlashdata('alert-class', 'alert-error');
			} else {
                sendMail(BOOK_APPOINTMENT_EMAIL_TEMPLATE,$newdata);
                session()->setFlashdata('msg', 'You have successfully make an appoinment. We will respond to you as soon as possible.');
                session()->setFlashdata('alert-class', 'alert-success');
				return redirect()->to(base_url('appointment'));	
			}
		}

        return view('frontend/appointment',$data);
    }

}
