<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;

class UserController extends BaseController
{
    public function login()
    {
        $data = [];
        $session = session();
        if ($this->request->getMethod() == 'post') {

            $rules = [
                'email' => 'required|min_length[6]|max_length[50]|valid_email',
                'password' => 'required|min_length[8]|max_length[255]',
            ];

            $errors = [
                'password' => [
                    'validateUser' => "Email or Password didn't match",
                ],
            ];
            if (!$this->validate($rules)) {

                return view('login', [
                    "validation" => $this->validator,
                ]);

            } else {
               
                $model = new UserModel();
                $user = $model->where('email', $this->request->getVar('email'))
                    ->first();
                if($user){
                    $pass = $user['password'];
                    $verify_pass = password_verify($this->request->getVar('password'), $pass);
                    if($verify_pass){
                        $this->setUserSession($user);
                        if($user['role'] == "admin"){
                            return redirect()->to(base_url('admin'));
                        }elseif($user['role'] == "editor"){
                            return redirect()->to(base_url('editor'));
                        }
                    }else{
                       $session->setFlashdata('msg', 'Incorrect password !');
                       return redirect()->to('/login'); 
                    }
                }else{
                    $session->setFlashdata('msg', 'email id not registered with us !');
                    return redirect()->to('/login'); 
                }

                
            }
        }
        return view('login');
    }

    private function setUserSession($user)
    {
        $data = [
            'id' => $user['id'],
            'name' => $user['name'],
            'phone_no' => $user['phone_no'],
            'email' => $user['email'],
            'isLoggedIn' => true,
            "role" => $user['role'],
        ];

        session()->set($data);
        return true;
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
}