<?php

function sendMail($mail_template,$data) { 
    $mail = \Config\Services::email();
    $mail->setTo($data['email']);
    $subject = subjectTitle($mail_template);
    $mail->setSubject($subject);
    $data['subject'] = $subject;
    // Using a custom template
    $template = view('emails/'.$mail_template, $data);
    $mail->setMessage($template);
    $mailDir = HARD_PATH . '/gen_mail';
    $fp = fopen($mailDir . '/mail_' . date('U') . '_' . rand(10000, 99999) . '.html', 'w');
    fwrite($fp, $template);
    fclose($fp);
    // Send email
    if ($mail->send()) {
        return true;
    } else {
        return false;
        //$res = $this->$email->printDebugger(['headers']);
    }
}

function subjectTitle($mail_template){
    // if($mail_template == SIGNUP_EMAIL_TEMPLATE){
    //     $subjectTitle = 'Welcome to '.APP_NAME.' | '.APP_NAME;
    // }

    if($mail_template == BOOK_APPOINTMENT_EMAIL_TEMPLATE){
        $subjectTitle = 'Appointment Request | '.APP_NAME;
    }

    if($mail_template == CONFIRM_APPOINTMENT_EMAIL_TEMPLATE){
        $subjectTitle = 'Appointment Confirmation | '.APP_NAME;
    }

    return $subjectTitle;

}