<?php

namespace App\Models;

use CodeIgniter\Model;

class AppointmentModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'tbl_appointment';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['id', 'appointment_code', 'type','service', 'patient','appointment_date','appointment_time','name','email', 'phone','msg','status'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'name' => 'trim|required',
        'email' => 'trim|required',
        'appointment_date' => 'trim|required',
    ];
    protected $validationMessages   = [
        'name' => [
            'required' => 'Please enter full name.',
        ],
        'email' => [
            'required' => 'Please enter email address.',
        ]
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;
    

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
