<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Appointments
        <small>patient appointment list</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Appointment</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
        <div class="box">
            <!-- <div class="box-header">
                <h3 class="box-title">Lab Package List</h3>
            </div> -->
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped ">
                <thead>
                <tr>
                  <th>Sr.No.</th>
                  <th>Clinic</th>
                  <th>Appointment</th>
                  <th>Patient</th>
                  <th>Service</th>
                  <th>Email</th>
                  <th>Phone</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
            <?php if($appointment): ?>
            <?php foreach($appointment as $key=>$value): ?>
                <?php if($value['status'] == 'P'){
                    $status = 'Pending';
                    $sclass = 'warning';
                }else if($value['status'] == 'C'){
                    $status = 'Confirmed';
                    $sclass = 'primary'; 
                }else{
                  $status = 'Rejected';
                  $sclass = 'danger'; 
                }
                ?>
                <tr>
                  <td><?php echo $key+1; ?></td>
                  <td> <?php if($value['clinic_name'] == 'C1'){ echo 'Zutshi Heart Clinic & Diagnostic Centre'; }else{ echo 'Doctors Point, Shipra Mall, Indrapuram'; } ?></td>
                  <td> <?php echo $value['type']; ?></td>
                  <td><?php echo $value['name']; ?></td>
                  <td> <?php echo $value['service']; ?></td>
                  <td><i class="fa fa-envelope" aria-hidden="true"></i> <?php echo $value['email']; ?></td>
                  <td><i class="fa fa-mobile" aria-hidden="true"></i> <?php echo $value['phone']; ?></td>
                  <td><span class="label label-<?=$sclass; ?>"><?=$status; ?></span></td>
                  <td>
                    <div class="btn-group">
                        <a href="<?php echo base_url('admin/editAppointment/'.$value['id']);?>" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                        <a href="#" class="btn btn-default"><i class="fa fa-trash"></i></a>
                    </div>
                </td>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
                </tbody>
                <!-- <tfoot>
                <tr>
                  <th>Sr.No.</th>
                  <th>Package</th>
                  <th>Price</th>
                  <th>Offered Price</th>
                  <th>Action</th>
                </tr>
                </tfoot> -->
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
    </div>

</section>

<?= $this->endSection() ?>