<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Categories
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?=base_url('admin/dashboard');?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="#">Categories</li>
        <li class="active">Add Catgory</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-4 mx-auto">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Add Categories</h3>
                </div>
                <?=form_open(base_url('admin/'.$action.'Categories')); ?>
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">Category Name</label>
                            <input type="hidden" id="id" name="id"  value="<?=set_value('id',@$cat['id']);?>" >
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter category name" value="<?=set_value('cat',@$cat['name']);?>" required>
                        </div>
                        <div class="form-group">
                            <label for="desc">Category Description</label>
                            <textarea class="form-control" id="description" name="description" rows="6" placeholder="Enter category description" required><?=set_value('description',@$cat['description']);?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="A" <?php if(set_value('status',@$cat['status']) == 'A'){ echo 'selected';} ?>>Active</option>
                                <option value="I" <?php if(set_value('status',@$cat['status']) == 'I'){ echo 'selected';} ?>>InActive</option>
                            </select>
                        </div>
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <?=form_open();?>
            </div>
        </div>
        <div class="col-md-8 mx-auto">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Categories List</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped ">
                <thead>
                <tr>
                  <th>Sr.No.</th>
                  <th>Category Name</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
            <?php if($categories): ?>
            <?php foreach($categories as $key=>$value): ?>
                <?php if($value['status'] == 'A'){
                    $status = 'Active';
                    $sclass = 'primary';
                }else{
                    $status = 'InActive';
                    $sclass = 'warning'; 
                }
                ?>
                <tr>
                  <td><?php echo $key+1; ?></td>
                  <td><?php echo $value['name']; ?></td>
                  <td><span class="label label-<?=$sclass; ?>"><?=$status; ?></span></td>
                  <td>
                    <div class="btn-group">
                        <a href="<?php echo base_url('admin/categories/'.$value['id']);?>" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                        <a href="#" class="btn btn-default"><i class="fa fa-trash"></i></a>
                    </div>
                </td>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
                </tbody>
                <!-- <tfoot>
                <tr>
                  <th>Sr.No.</th>
                  <th>Package</th>
                  <th>Price</th>
                  <th>Offered Price</th>
                  <th>Action</th>
                </tr>
                </tfoot> -->
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
    </div>
</section>
            <?= $this->endSection() ?>