<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Lab Test Extra Details
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?=base_url('admin/dashboard');?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="#">Lab Test Extra Details</li>
        <li class="active">Add Test Extra Details</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-4 mx-auto">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Add Test Extra Details</h3>
                </div>
                <?=form_open_multipart(base_url('admin/'.$action.'Extra')); ?>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label for="title">Test</label>
                                    <select class="form-control" name="testId" id="testId">
                                        <option value="<?=$test['id']; ?>" ><?=$test['title']; ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label for="title">Question</label>
                                    <input type="hidden" id="id" name="id"  value="<?=set_value('id',@$row['id']);?>" >
                                    <input type="text" class="form-control" id="question" name="question" value="<?=set_value('question',@$row['question']);?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="desc">Answer</label>
                            <textarea class="form-control" id="editor1" name="answer" rows="5" cols="40"  required><?=set_value('answer',@$row['answer']);?></textarea>
                        </div>

                        <div class="row">
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label for="type">Type</label>
                                    <select class="form-control" name="type" id="type" required>
                                        <option value="" >Please select</option>
                                        <option value="TC" <?php if(set_value('type',@$row['type']) == 'TC'){ echo 'selected';} ?>>Test Criteria</option>
                                        <option value="TP" <?php if(set_value('type',@$row['type']) == 'TP'){ echo 'selected';} ?>>Test Parameters</option>
                                        <option value="QA" <?php if(set_value('type',@$row['type']) == 'QA'){ echo 'selected';} ?>>Question/Answer</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control" name="status" id="status">
                                        <option value="A" <?php if(set_value('status',@$row['status']) == 'A'){ echo 'selected';} ?>>Active</option>
                                        <option value="I" <?php if(set_value('status',@$row['status']) == 'I'){ echo 'selected';} ?>>InActive</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                       
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <?=form_open();?>
            </div>
        </div>
        <div class="col-md-8 mx-auto">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Lab Test Extra Deatils</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped ">
                <thead>
                <tr>
                  <th>Sr.No.</th>
                  <th>Test</th>
                  <th>Type</th>
                  <th>Question</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
            <?php if($data): ?>
            <?php foreach($data as $key=>$value): ?>
                <?php if($value['status'] == 'A'){
                    $status = 'Active';
                    $sclass = 'primary';
                }else{
                    $status = 'InActive';
                    $sclass = 'warning'; 
                }
                ?>
                <tr>
                  <td><?php echo $key+1; ?></td>
                  <td><?php echo $test['title']; ?></td>
                  <td><?=$value['type']; ?></td>
                  <td><i class="fa fa-answer" aria-hidden="true"></i> <?=word_limiter($value['question'],5); ?></td>
                  <td><span class="label label-<?=$sclass; ?>"><?=$status; ?></span></td>
                  <td>
                    <div class="btn-group">
                        <a href="<?php echo base_url('admin/labtest/extra/'.$value['testId'].'_'.$value['id']);?>" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                        <a href="#" class="btn btn-default"><i class="fa fa-trash"></i></a>
                    </div>
                </td>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
                </tbody>
                <!-- <tfoot>
                <tr>
                  <th>Sr.No.</th>
                  <th>Package</th>
                  <th>Price</th>
                  <th>Offered Price</th>
                  <th>Action</th>
                </tr>
                </tfoot> -->
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
    </div>
</section>

            <?= $this->endSection() ?>