<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Lab Test
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?=base_url('admin/dashboard');?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="#">Lab Tests</li>
        <li class="active">Add Test</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Add Test</h3>
                </div>
                <?=form_open_multipart(base_url('admin/'.$action.'Test')); ?>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label for="title">Title</label>
                                    <input type="hidden" id="id" name="id"  value="<?=set_value('id',@$row['id']);?>" >
                                    <input type="text" class="form-control" id="title" name="title" value="<?=set_value('title',@$row['title']);?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="desc">Short Description</label>
                            <textarea class="form-control" id="short_desc" name="short_desc" rows="2" placeholder="Enter short description" required><?=set_value('short_desc',@$row['short_desc']);?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="desc">Blog Content</label>
                            <textarea class="form-control" id="editor1" name="long_desc" rows="5" cols="40"  required><?=set_value('long_desc',@$row['long_desc']);?></textarea>
                        </div>
                        <div class="row">
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label for="title">Fasting</label>
                                    <input type="text" class="form-control" id="fasting" name="fasting" value="<?=set_value('fasting',@$row['fasting']);?>">
                                </div>
                            </div>
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label for="title">Get Reports In</label>
                                    <input type="text" class="form-control" id="gri" name="gri" value="<?=set_value('gri',@$row['gri']);?>" >
                                </div>
                            </div>
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label for="title">Home Collection</label>
                                    <input type="text" class="form-control" id="hc" name="hc" value="<?=set_value('hc',@$row['hc']);?>" >
                                </div>
                            </div>
                            <div class="col-xs-3">
                                <div class="form-group">
                                    <label for="title">Age Group</label>
                                    <input type="text" class="form-control" id="ag" name="ag" value="<?=set_value('ag',@$row['ag']);?>" >
                                </div>
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="title">Price</label>
                                    <input type="text" class="form-control" id="price" name="price" value="<?=set_value('price',@$row['price']);?>" required>
                                </div>
                            </div>
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="title">Discount Price</label>
                                    <input type="text" class="form-control" id="sprice" name="sprice" value="<?=set_value('sprice',@$row['sprice']);?>" required>
                                </div>
                            </div>
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control" name="status" id="status">
                                        <option value="A" <?php if(set_value('status',@$row['status']) == 'A'){ echo 'selected';} ?>>Active</option>
                                        <option value="I" <?php if(set_value('status',@$row['status']) == 'I'){ echo 'selected';} ?>>InActive</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="banner">Banner</label>
                                    <input type="file" class="form-control" id="banner" name="banner" value="<?=set_value('banner',@$row['banner']);?>" onchange="readURL(this);">
                                    <input name="old_banner" type="hidden" id="old_banner" value="<?= set_value('old_banner',@$row['banner']); ?>">
                                </div>
                            </div>
                            <div class="col-xs-4">
                            <?php if(!empty($row['banner'])){ ?>
                                <img id="blah" src="<?php echo base_url('uploads/'.$row['banner']); ?>" class="img-thumbnail" width="80" height="60" />
                                <?php }else{ ?>
                                    <img id="blah" src="//www.tutsmake.com/wp-content/uploads/2019/01/no-image-tut.png" class="img-thumbnail" width="80" height="60" />
                                <?php } ?>
                            </div>
                            
                            
                        </div>
                        
                       
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <?=form_open();?>
            </div>
        </div>
        <div class="col-md-6 mx-auto">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Lab Test List</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped ">
                <thead>
                <tr>
                  <th>Sr.No.</th>
                  <th>Title</th>
                  <th>Price</th>
                  <th>DPrice</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
            <?php if($data): ?>
            <?php foreach($data as $key=>$value): ?>
                <?php if($value['status'] == 'A'){
                    $status = 'Active';
                    $sclass = 'primary';
                }else{
                    $status = 'InActive';
                    $sclass = 'warning'; 
                }
                ?>
                <tr>
                  <td><?php echo $key+1; ?></td>
                  <td><?php echo word_limiter($value['title'],3); ?></td>
                  <td><del><i class="fa fa-inr" aria-hidden="true"></i> <?=$value['price']; ?></del></td>
                  <td><i class="fa fa-inr" aria-hidden="true"></i> <?=$value['sprice']; ?></td>
                  <td><span class="label label-<?=$sclass; ?>"><?=$status; ?></span></td>
                  <td>
                    <div class="btn-group">
                        <a href="<?php echo base_url('admin/labtest/'.$value['id']);?>" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                        <a href="<?php echo base_url('admin/labtest/extra/'.$value['id']);?>" class="btn btn-default"><i class="fa fa-question"></i></a>
                        <a href="<?php echo base_url('admin/labtest/delete/'.$value['id']);?>" class="btn btn-default" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i></a>
                    </div>
                </td>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
                </tbody>
                <!-- <tfoot>
                <tr>
                  <th>Sr.No.</th>
                  <th>Package</th>
                  <th>Price</th>
                  <th>Offered Price</th>
                  <th>Action</th>
                </tr>
                </tfoot> -->
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
    </div>
</section>

            <?= $this->endSection() ?>