<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Package
        <small>Preview</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Package</a></li>
        <li class="active">Add Package</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Update Package</h3>
                </div>
                <?=form_open(base_url('admin/updatePackage')); ?>
                <input type="hidden" name="id" id="id" value="<?php echo $package['id']; ?>">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">Package Title</label>
                            <input type="text" class="form-control" id="title" name="title" placeholder="Enter package title" value="<?php echo $package['title']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="desc">Package Description</label>
                            <textarea class="form-control" id="desc" name="desc" rows="6" placeholder="Enter package description" required><?php echo $package['desc']; ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="title">Price</label>
                            <input type="price" class="form-control" id="price" name="price" placeholder="Enter price" value="<?php echo $package['price']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="title">Offered Price</label>
                            <input type="text" class="form-control" id="sprice" name="sprice" placeholder="Enter offered price" value="<?php echo $package['sprice']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="A" <?php if($package['status'] == 'A'){ echo 'selected'; } ?>>Active</option>
                                <option value="I" <?php if($package['status'] == 'I'){ echo 'selected'; } ?>>InActive</option>
                            </select>
                        </div>
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="featured" <?php if($package['featured'] == 'Y'){ echo 'checked'; } ?>> Featured
                            </label>
                        </div>
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <?=form_open();?>
            </div>
        </div>
    </div>
</section>
            <?= $this->endSection() ?>