<?= $this->extend("layouts/app") ?>
<?= $this->section("body") ?>
<section class="content-header">
    <h1>
        Posts
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?=base_url('admin/dashboard');?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="#">Posts</li>
        <li class="active">Add Post</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Add Post</h3>
                </div>
                <?=form_open_multipart(base_url('admin/'.$action.'Post')); ?>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-8">
                                <div class="form-group">
                                    <label for="title">Title</label>
                                    <input type="hidden" id="id" name="id"  value="<?=set_value('id',@$post['id']);?>" >
                                    <input type="text" class="form-control" id="title" name="title" placeholder="Enter blog title" value="<?=set_value('title',@$post['title']);?>" required>
                                </div>
                            </div>
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select class="form-control" name="category_id" id="category_id">
                                    <?php foreach($categories as $key =>$value): ?>
                                        <option value="<?=$value['id'];?>" <?php if(set_value('category_id',@$post['category_id']) == $value['id']){ echo 'selected';} ?>><?=$value['name'];?></option>
                                    <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="title">Slug Url</label>
                            <input type="text" class="form-control" id="slug" name="slug" placeholder="Enter slug url" value="<?=set_value('slug',@$post['slug']);?>" >
                        </div>
                        <div class="form-group">
                            <label for="desc">Short Description</label>
                            <textarea class="form-control" id="short_desc" name="short_desc" rows="4" placeholder="Enter short description" required><?=set_value('short_desc',@$post['short_desc']);?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="desc">Blog Content</label>
                            <textarea class="form-control" id="editor1" name="content" rows="10" cols="80"  required><?=set_value('content',@$post['content']);?></textarea>
                        </div>
                        <div class="row">
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="banner">Banner</label>
                                    <input type="file" class="form-control" id="banner" name="banner" value="<?=set_value('banner',@$post['banner']);?>" onchange="readURL(this);">
                                    <input name="old_banner" type="hidden" id="old_banner" value="<?= set_value('old_banner',@$post['banner']); ?>">
                                </div>
                            </div>
                            <div class="col-xs-4">
                            <?php if(@$post['banner']){ ?>
                                <img id="blah" src="<?php echo UPLOAD_PATH.$post['banner']; ?>" class="img-thumbnail" width="80" height="60" />
                                <?php }else{ ?>
                                    <img id="blah" src="//www.tutsmake.com/wp-content/uploads/2019/01/no-image-tut.png" class="img-thumbnail" width="80" height="60" />
                                <?php } ?>
                            </div>
                            
                            <div class="col-xs-4">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control" name="status" id="status">
                                        <option value="A" <?php if(set_value('status',@$post['status']) == 'A'){ echo 'selected';} ?>>Active</option>
                                        <option value="I" <?php if(set_value('status',@$post['status']) == 'I'){ echo 'selected';} ?>>InActive</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                       
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                    <?=form_open();?>
            </div>
        </div>
        <div class="col-md-6 mx-auto">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Post/Blog List</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped ">
                <thead>
                <tr>
                  <th>Sr.No.</th>
                  <th>Title</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
            <?php if($posts): ?>
            <?php foreach($posts as $key=>$value): ?>
                <?php if($value['status'] == 'A'){
                    $status = 'Active';
                    $sclass = 'primary';
                }else{
                    $status = 'InActive';
                    $sclass = 'warning'; 
                }
                ?>
                <tr>
                  <td><?php echo $key+1; ?></td>
                  <td><?php echo $value['title']; ?></td>
                  <td><span class="label label-<?=$sclass; ?>"><?=$status; ?></span></td>
                  <td>
                    <div class="btn-group">
                        <a href="<?php echo base_url('admin/post/'.$value['id']);?>" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                        <a href="#" class="btn btn-default"><i class="fa fa-trash"></i></a>
                    </div>
                </td>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
                </tbody>
                <!-- <tfoot>
                <tr>
                  <th>Sr.No.</th>
                  <th>Package</th>
                  <th>Price</th>
                  <th>Offered Price</th>
                  <th>Action</th>
                </tr>
                </tfoot> -->
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
    </div>
</section>

            <?= $this->endSection() ?>