<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header border-0">
                        <h5 class="mb-0 card-title border-0 text-uppercase">24 Hours & 48 Hours Ambulatory Blood Pressure Monitoring</h5>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/banner-bpmonitor.jpg"
                        alt="Ambulatory Blood Pressure Monitoring">
                    <div class="card-body">
                        <p class="text-muted">ABPM stands for Ambulatory Blood Pressure Monitoring. It is a non-invasive medical test that measures blood pressure at regular intervals throughout a 24-hour period, typically every 15 to 30 minutes during the day and every 30 to 60 minutes at night. ABPM is performed using a small, portable device that is worn on a belt around your waist and connected to a cuff around your upper arm.
									</p>
                        <h5 class="card-title text-muted">Here are some important things to know about ABPM:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">Purpose:</span> The purpose of ABPM is to get an accurate and complete picture of your blood pressure over a 24-hour period, which can help your doctor diagnose and manage high blood pressure (hypertension). ABPM can also help identify white coat hypertension (elevated blood pressure in a clinical setting) and nocturnal hypertension (elevated blood pressure during sleep).
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Procedure:</span> To prepare for ABPM, you will be asked to wear comfortable clothing and avoid any strenuous activity or alcohol for at least 30 minutes before the test. The device will be fitted onto your arm and you will be instructed to keep your arm still during measurements. You will be given a diary to record your activities and symptoms during the test.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Duration:</span> ABPM usually lasts for 24 hours, during which you will go about your daily activities and sleep as usual. The device will automatically inflate the cuff and measure your blood pressure at the set intervals throughout the day and night.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Interpretation of results:</span> Your doctor will review the results of your ABPM to determine if you have hypertension or other blood pressure-related issues. The results can also help your doctor determine the effectiveness of your blood pressure medication and make adjustments if needed.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Benifits:</span> ABPM provides more comprehensive information about your blood pressure than a single office measurement, which can help your doctor make a more accurate diagnosis and treatment plan. ABPM is also more convenient than frequent office visits for blood pressure measurement, and it may help reduce the number of unnecessary medications prescribed for hypertension.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Risks:</span> ABPM is generally safe, but some people may experience discomfort or skin irritation from the cuff or the adhesive used to secure the device. In rare cases, ABPM can cause bruising or nerve damage. If you experience any discomfort or pain during the test, notify your doctor immediately.
                            </li>
                        </ul>
                       
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>