<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header border-0">
                        <h5 class="mb-0 card-title border-0 text-uppercase">Dobutamine Stress Echocardiography</h5>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/dse.jpg"
                        alt="Dobutamine Stress Echocardiography">
                    <div class="card-body">
                        <p class="text-muted">Dobutamine stress echocardiography (DSE) is a non-invasive medical test used to evaluate the heart's response to stress. It involves the use of dobutamine, a medication that mimics the effects of exercise on the heart, to increase the heart rate and blood flow while an echocardiogram is performed to assess the heart's function.
						</p>
                        <h5 class="card-title text-muted">Here are some important things to know about DSE:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">Purpose:</span> The purpose of DSE is to evaluate the function of the heart during stress and detect any abnormalities that may not be apparent during rest. It is commonly used to diagnose and assess the severity of coronary artery disease, valvular heart disease, and other heart conditions.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Procedure:</span> To prepare for DSE, you may need to avoid eating or drinking for a few hours before the test. You may also be asked to avoid certain medications that could affect the results of the test. During the test, you will lie down on a table while a small intravenous (IV) line is inserted into your arm. A medication called dobutamine will be administered through the IV to increase your heart rate and simulate the effects of exercise. An echocardiogram will be performed before and after the administration of the medication.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Limitations:</span> DSE is a safe and effective test, but it has some limitations. It is not recommended for people who have severe asthma or chronic obstructive pulmonary disease (COPD), as it can exacerbate breathing difficulties. It may also be less effective in people who have poor echocardiographic images due to obesity, lung disease, or other factors.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Interpretation of results:</span> After the test, the images obtained during the echocardiogram will be analyzed to assess the function of the heart at rest and during stress. The results can help your doctor diagnose or evaluate the severity of heart conditions such as coronary artery disease or heart valve problems.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Benifits:</span> DSE is a non-invasive and relatively safe way to assess the function of the heart during stress, without the risks associated with actual exercise. It can provide valuable information that may not be apparent during rest, which can aid in the diagnosis and management of heart conditions.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Risks:</span> DSE is generally safe, but some people may experience side effects from the medication, such as headaches, nausea, or palpitations. Rarely, serious complications such as arrhythmias, heart attack, or stroke may occur. However, these complications are extremely rare and occur in less than 1% of cases.
                            </li>
                        </ul>
                       
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>