<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header">
                        <h5 class="mb-0 card-title border-0 text-uppercase">Holter Monitoring</h45>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/holter-monitoring.jpg"
                        alt="Holter Monitoring">
                    <div class="card-body">
                        <p class="text-muted">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time, usually 24 to 48 hours and up to 7 days using a small portable device called a Holter monitor. This type of monitoring is useful for detecting abnormal heart rhythms, which can be symptoms of various heart conditions such as arrhythmias, palpitations, or syncope.
						</p>
                        <h5 class="card-title text-muted">Here are some important things to know about Holter monitoring:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">Purpose:</span> The purpose of Holter monitoring is to record and analyze the electrical activity of your heart over a period of time. This helps your doctor diagnose abnormal heart rhythms that may not show up during a standard electrocardiogram (ECG) test.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Procedure:</span> To prepare for Holter monitoring, you may need to avoid applying lotions or oils to your chest and avoid taking a bath or shower. The technician will attach electrodes to your chest, which are connected to a small, portable device called a Holter monitor. The monitor records your heart's electrical activity as you go about your normal activities for 24 to 48 hours.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Duration:</span> Holter monitoring usually lasts for 24 to 48 hours, although it can be longer depending on your specific condition. During this time, you will wear the Holter monitor and go about your daily routine as usual, including exercise and sleep.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Benifits:</span> Holter monitoring provides a more comprehensive and extended view of your heart's electrical activity compared to a standard ECG test. This can help your doctor diagnose heart conditions that may not show up during a brief office visit.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Risks:</span> Holter monitoring is generally safe, but some people may experience skin irritation from the electrodes or discomfort from wearing the monitor. The electrodes may also come loose or fall off during the monitoring period, which can affect the accuracy of the test. In rare cases, people may experience an allergic reaction to the adhesive used to attach the electrodes.
                            </li>
                        </ul>
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>