<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header border-0">
                        <h5 class="mb-0 card-title border-0 text-uppercase">Pulmonary Function Test</h5>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/banner-pulmonary.jpg"
                        alt="Pulmonary Function Test">
                    <div class="card-body">
                        <p class="text-muted">PFT stands for Pulmonary Function Test, a non-invasive medical test used to evaluate lung function. It measures the amount of air you can inhale and exhale, the speed of your breath, and how effectively your lungs transfer oxygen into your bloodstream.
									</p>
                        <h5 class="card-title text-muted">Here are some important things to know about PFT:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">Purpose:</span> The purpose of PFT is to assess lung function, diagnose lung diseases such as asthma, chronic obstructive pulmonary disease (COPD), or pulmonary fibrosis, and monitor the effectiveness of treatment. It is also used to evaluate lung function before surgery or to assess the impact of environmental or occupational exposure on lung function.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Procedure:</span> To prepare for PFT, you may need to avoid smoking or using bronchodilators for several hours before the test. The test is performed by breathing into a device called a spirometer, which measures the volume and speed of your breath. You may also be asked to perform other breathing maneuvers, such as rapid and deep breathing or holding your breath for several seconds.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Type of PFT:</span> There are several types of PFT, including spirometry, lung volume measurement, diffusion capacity measurement, and bronchial provocation testing. Each type of PFT measures a different aspect of lung function and may be used to diagnose different lung conditions.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Interpretation of results:</span> After the test, the results are analyzed to evaluate lung function and diagnose any underlying conditions. Your doctor may compare the results to normal values based on your age, height, weight, and sex. They may also compare your results to previous PFTs to monitor changes in lung function over time.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Benifits:</span> PFT is a non-invasive and relatively safe way to assess lung function, which can help diagnose and manage lung conditions. It can provide valuable information that may not be apparent from physical examination or imaging tests.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Risks:</span> PFT is generally safe, but some people may experience dizziness, lightheadedness, or shortness of breath during the test. Rarely, serious complications such as a collapsed lung may occur. However, these complications are extremely rare and occur in less than 1% of cases.
                            </li>
                        </ul>
                       
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>