<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header border-0">
                        <h5 class="mb-0  border-0 text-uppercase" >Stress Echocardiogram</h5>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/stress-echo.jpg"
                        alt="Stress Echocardiogram">
                    <div class="card-body">
                        <p class="text-muted">A stress echocardiogram (stress echo) is a medical test that combines a standard echocardiogram with an exercise stress test to evaluate how well your heart functions under stress. While stress echocardiogram is a useful tool in diagnosing heart problems, there are some limitations to the test. 
									</p>
                        <h5 class="card-title text-muted">Limitations of stress echocardiogram:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">False positive results:</span> In some cases, stress echocardiogram may show abnormalities that are not actually present. This can happen if there is an error in the test, or if there are other underlying health conditions that can cause similar symptoms.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">False negative results:</span>In some cases, stress echocardiogram may not detect underlying heart problems that are present. This can happen if the blockage is very small or if it is located in an area that is difficult to see with the test.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Limited visualization:</span> Stress echocardiogram provides limited visualization of the heart compared to other imaging tests such as CT or MRI. The image quality may also be reduced during exercise when the heart rate is high.
                            </li>
                        </ul>
                        <h5 class="card-title text-muted">Limitations of stress echocardiogram:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                            Avoid food and drinks for 4 hours prior to the test.
                            </li>
                            <li class="mb-1">
                            Wear comfortable clothing and shoes suitable for exercise.
                            </li>
                            <li class="mb-1">
                            Inform your doctor about any medications you are taking, especially if you are taking medications for heart problems.
                            </li>
                            <li class="mb-1">
                            Do not smoke, drink caffeine, or take any stimulants for at least 4 hours prior to the test.
                            </li>
                            <li class="mb-1">
                            During the test, you will be asked to walk on a treadmill or pedal a stationary bike while your heart rate is monitored. The exercise may be stopped if you experience chest pain, shortness of breath, or other symptoms.
                            </li>
                            <li class="mb-1">After the exercise, you will lie down and a technician will perform an echocardiogram to assess how well your heart is functioning.</li>
                            <li class="mb-1">The entire test usually takes about an hour, and you should be able to return to your normal activities immediately afterward.</li>
                        </ul>
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>