<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<!-- Start -->
<section class="section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 mt-4">
                <div class="card rounded shadow border-0 overflow-hidden">
                    <div class="card-header border-0">
                        <h5 class="mb-0 card-title text-uppercase">Treadmill Test</h5>
                    </div>
                    <img class="img-fluid"
                        src="<?=base_url();?>uploads/services/tmt-test.jpg"
                        alt="Treadmill Test">
                    <div class="card-body">
                        <p class="text-muted">A treadmill test, also known as an exercise stress test, is a
                            medical test that evaluates how well your heart functions during physical activity. It
                            involves walking on a treadmill or pedaling a stationary bike while your heart rate and
                            rhythm are monitored. While a treadmill test can provide valuable information about your
                            heart health, there are some limitations and instructions you should be aware of:</p>
                        <h5 class="card-title text-muted">Limitations of a treadmill test:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                <span class="fw-bold">False positive results:</span> A treadmill test may show abnormalities that are not actually present. This can happen if there is an error in the test or if there are other underlying health conditions that can cause similar symptoms.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">False negative results:</span> A treadmill test may not detect underlying heart problems that are
                            present, especially if the blockage is very small or if it is located in an area that is
                            difficult to see with the test.
                            </li>
                            <li class="mb-1">
                                <span class="fw-bold">Limited visualization:</span> A treadmill test provides limited visualization of the heart
                            compared to other imaging tests such as CT or MRI.
                            </li>
                        </ul>
                        <h5 class="card-title text-muted">Instructions for a treadmill test:</h5>
                        <ul class="list-styled text-muted">
                            <li class="mb-1">
                                Wear comfortable clothing and shoes suitable for exercise.
                            </li>
                            <li class="mb-1">
                                Avoid food, drinks, and medications for a certain period of time prior to the test, as
                                instructed by your doctor.
                            </li>
                            <li class="mb-1">
                                Do not smoke, drink caffeine, or take any stimulants for at least 4 hours prior to the
                                test.
                            </li>
                            <li class="mb-1">
                                During the test, you will be asked to walk on a treadmill or pedal a stationary bike
                                while your heart rate is monitored. The exercise may be stopped if you experience chest
                                pain, shortness of breath, or other symptoms.
                            </li>
                            <li class="mb-1">
                                The duration and intensity of the exercise will gradually increase until you reach a
                                target heart rate, which is determined based on your age and fitness level. of breath,
                                or other symptoms.
                            </li>
                            <li class="mb-1">After the exercise, you will be monitored for a short period of time to
                                assess how well your heart is recovering.</li>
                        </ul>
                        <p class="text-muted">The entire test usually takes about 30 minutes to an hour, and you should
                            be able to return to your normal activities immediately afterward.</p>
                    </div>
                    <div class="card-footer bg-white border-0">
                        <a href="<?=base_url('appointment');?>" class="btn btn-soft-primary d-print-none"><i class="uil uil-calender"></i> Book An Appointment</a>
                    </div>
                </div>
            </div>
            <!--end col-->
        </div>
        <!--end row-->
    </div>
    <!--end container-->
</section>
<!--end section-->
<!-- End -->

<?= $this->endSection(); ?>