
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Our Services</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Dobutamine Stress Echocardiogram</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	




			<!-- TABS-2
			============================================= -->
			<section id="tabs-2" class="wide-100 tabs-section division">
				<div class="container">	
				 	<div class="row">


				 		<!-- TABS NAVIGATION -->
				 		<div class="col-lg-4">
							<div id="tabs-nav" class="list-group text-center clearfix">
							    <ul class="nav nav-pills" id="pills-tab" role="tablist">

							    	<!-- TAB-2 LINK -->
									<li class="nav-item icon-xs">
									    <a class="nav-link" id="tab2-list" data-toggle="pill" href="#tab-2" role="tab" aria-controls="tab-2" aria-selected="false">
									       Treadmill Test
									    </a>
									</li>

                                    <!-- TAB-4 LINK -->
									<li class="nav-item icon-xs">
									    <a class="nav-link" id="tab4-list" data-toggle="pill" href="#tab-4" role="tab" aria-controls="tab-4" aria-selected="false">
									       Holter Monitoring
									    </a>
									</li>

							    	<!-- TAB-1 LINK -->
								  	<li class="nav-item icon-xs">
								    	<a class="nav-link " id="tab1-list" data-toggle="pill" href="#tab-1" role="tab" aria-controls="tab-1" aria-selected="false">
								    		Stress Echocardiogram
								    	</a>
								  	</li>

								  	<!-- TAB-6 LINK -->
									<li class="nav-item icon-xs">
									    <a class="nav-link" id="tab5-list" data-toggle="pill" href="#tab-6" role="tab" aria-controls="tab-6" aria-selected="false">
									       Pulmonary Function Test
									    </a>
									</li>

                                    <!-- TAB-5 LINK -->
									<li class="nav-item icon-xs">
									    <a class="nav-link active" id="tab5-list" data-toggle="pill" href="#tab-5" role="tab" aria-controls="tab-5" aria-selected="false">
									       Dobutamine Stress Echocardiogram
									    </a>
									</li>

									<!-- TAB-3 LINK -->
									<li class="nav-item icon-xs">
									    <a class="nav-link" id="tab3-list" data-toggle="pill" href="#tab-3" role="tab" aria-controls="tab-3" aria-selected="false">
									       24 Hours & 48 Hours Ambulatory Blood Pressure Monitoring
									    </a>
									</li>

									

								
									

								</ul>

							</div>	
						</div>	<!-- END TABS NAVIGATION -->


						<!-- TABS CONTENT -->
				 		<div class="col-lg-8">
							<div class="tab-content" id="pills-tabContent">


								<!-- TAB-1 CONTENT -->
								<div class="tab-pane fade" id="tab-1" role="tabpanel" aria-labelledby="tab1-list">									
									<!-- Title -->
									<h3 class="h3-md steelblue-color">Stress Echocardiogram</h3>

									<!-- Text -->
									<p class="text-justify">A stress echocardiogram (stress echo) is a medical test that combines a standard echocardiogram with an exercise stress test to evaluate how well your heart functions under stress. While stress echocardiogram is a useful tool in diagnosing heart problems, there are some limitations to the test. 
									</p>

									<!-- Image -->
									<div class="tab-img">
										<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/stress-echo.jpg" alt="Stress Echocardiogram" />
									</div>

									<!-- Text -->
									<p>Here are some of the limitations and instructions related to stress echocardiogram:</p>
									<p class="font-weight-bold">Limitations of stress echocardiogram:</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False positive results:</strong> In some cases, stress echocardiogram may show abnormalities that are not actually present. This can happen if there is an error in the test, or if there are other underlying health conditions that can cause similar symptoms.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False negative results:</strong> In some cases, stress echocardiogram may not detect underlying heart problems that are present. This can happen if the blockage is very small or if it is located in an area that is difficult to see with the test.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Limited visualization:</strong> Stress echocardiogram provides limited visualization of the heart compared to other imaging tests such as CT or MRI. The image quality may also be reduced during exercise when the heart rate is high.</p>				
											</div>

										</div>
									</div>	<!-- End Options List -->
									<p class="font-weight-bold">Limitations of stress echocardiogram:</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Avoid food and drinks for 4 hours prior to the test.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Wear comfortable clothing and shoes suitable for exercise.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Inform your doctor about any medications you are taking, especially if you are taking medications for heart problems.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Do not smoke, drink caffeine, or take any stimulants for at least 4 hours prior to the test.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>During the test, you will be asked to walk on a treadmill or pedal a stationary bike while your heart rate is monitored. The exercise may be stopped if you experience chest pain, shortness of breath, or other symptoms.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>After the exercise, you will lie down and a technician will perform an echocardiogram to assess how well your heart is functioning.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>The entire test usually takes about an hour, and you should be able to return to your normal activities immediately afterward.</p>				
											</div>

										</div>
									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>

								</div>	<!-- END TAB-1 CONTENT -->


								<!-- TAB-2 CONTENT -->
								<div class="tab-pane fade" id="tab-2" role="tabpanel" aria-labelledby="tab2-list">

									<!-- Title -->
									<h3 class="h3-md steelblue-color">Treadmill Test</h3>

									<!-- Text -->
									<p>A treadmill test, also known as an exercise stress test, is a medical test that evaluates how well your heart functions during physical activity. It involves walking on a treadmill or pedaling a stationary bike while your heart rate and rhythm are monitored. While a treadmill test can provide valuable information about your heart health, 
									</p>

									<!-- Image -->
									<div class="tab-img">
										<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/tmt-test.jpg" alt="Treadmill Test" />
									</div>

									<!-- Text -->
									<p>there are some limitations and instructions you should be aware of:
									</p>
									<p class="font-weight-bold">Limitations of a treadmill test:</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False positive results:</strong> A treadmill test may show abnormalities that are not actually present. This can happen if there is an error in the test or if there are other underlying health conditions that can cause similar symptoms.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False negative results:</strong> A treadmill test may not detect underlying heart problems that are present, especially if the blockage is very small or if it is located in an area that is difficult to see with the test.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Limited visualization:</strong> A treadmill test provides limited visualization of the heart compared to other imaging tests such as CT or MRI.</p>				
											</div>

										</div>

									</div>	<!-- End Options List -->
									<p class="font-weight-bold">Instructions for a treadmill test:</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Wear comfortable clothing and shoes suitable for exercise.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Avoid food, drinks, and medications for a certain period of time prior to the test, as instructed by your doctor.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Do not smoke, drink caffeine, or take any stimulants for at least 4 hours prior to the test.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>During the test, you will be asked to walk on a treadmill or pedal a stationary bike while your heart rate is monitored. The exercise may be stopped if you experience chest pain, shortness of breath, or other symptoms.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>The duration and intensity of the exercise will gradually increase until you reach a target heart rate, which is determined based on your age and fitness level.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>After the exercise, you will be monitored for a short period of time to assess how well your heart is recovering.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>The entire test usually takes about 30 minutes to an hour, and you should be able to return to your normal activities immediately afterward.</p>				
											</div>

										</div>
									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>
										
								</div>	<!-- END TAB-2 CONTENT -->


								<!-- TAB-3 CONTENT -->
								<div class="tab-pane fade" id="tab-3" role="tabpanel" aria-labelledby="tab3-list">

									<!-- Title -->
									<h3 class="h3-md steelblue-color">24 Hours & 48 Hours Ambulatory Blood Pressure Monitoring</h3>

									<!-- Text -->
									<p>ABPM stands for Ambulatory Blood Pressure Monitoring. It is a non-invasive medical test that measures blood pressure at regular intervals throughout a 24-hour period, typically every 15 to 30 minutes during the day and every 30 to 60 minutes at night. ABPM is performed using a small, portable device that is worn on a belt around your waist and connected to a cuff around your upper arm.
									</p>

									<!-- Image -->
									<div class="tab-img">
										<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/bpmonitor.jpg" alt="BP Monitoring" />
									</div>

									<!-- Text -->
                                    <p class="font-weight-bold">Here are some important things to know about ABPM:</p>
									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of ABPM is to get an accurate and complete picture of your blood pressure over a 24-hour period, which can help your doctor diagnose and manage high blood pressure (hypertension). ABPM can also help identify white coat hypertension (elevated blood pressure in a clinical setting) and nocturnal hypertension (elevated blood pressure during sleep).</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for ABPM, you will be asked to wear comfortable clothing and avoid any strenuous activity or alcohol for at least 30 minutes before the test. The device will be fitted onto your arm and you will be instructed to keep your arm still during measurements. You will be given a diary to record your activities and symptoms during the test.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Duration:</strong> ABPM usually lasts for 24 hours, during which you will go about your daily activities and sleep as usual. The device will automatically inflate the cuff and measure your blood pressure at the set intervals throughout the day and night.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong> Your doctor will review the results of your ABPM to determine if you have hypertension or other blood pressure-related issues. The results can also help your doctor determine the effectiveness of your blood pressure medication and make adjustments if needed.</p>
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benefits:</strong> ABPM provides more comprehensive information about your blood pressure than a single office measurement, which can help your doctor make a more accurate diagnosis and treatment plan. ABPM is also more convenient than frequent office visits for blood pressure measurement, and it may help reduce the number of unnecessary medications prescribed for hypertension.</p>
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> ABPM is generally safe, but some people may experience discomfort or skin irritation from the cuff or the adhesive used to secure the device. In rare cases, ABPM can cause bruising or nerve damage. If you experience any discomfort or pain during the test, notify your doctor immediately.</p>
											</div>

										</div>

									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>
										
								</div>	<!-- END TAB-3 CONTENT -->


								<!-- TAB-4 CONTENT -->
								<div class="tab-pane fade" id="tab-4" role="tabpanel" aria-labelledby="tab4-list">

									<!-- Title -->
									<h3 class="h3-md steelblue-color">Holter monitoring</h3>

									<!-- Text -->
									<p>Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time, usually 24 to 48 hours and up to 7 days using a small portable device called a Holter monitor. This type of monitoring is useful for detecting abnormal heart rhythms, which can be symptoms of various heart conditions such as arrhythmias, palpitations, or syncope.
									</p>

									<!-- Image -->
									<div class="tab-img">
										<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/holter-monitoring.jpg" alt="Holter Monitoring" />
									</div>

									<!-- Text -->
									<p class="font-weight-bold">Here are some important things to know about Holter monitoring:
									</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of Holter monitoring is to record and analyze the electrical activity of your heart over a period of time. This helps your doctor diagnose abnormal heart rhythms that may not show up during a standard electrocardiogram (ECG) test.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for Holter monitoring, you may need to avoid applying lotions or oils to your chest and avoid taking a bath or shower. The technician will attach electrodes to your chest, which are connected to a small, portable device called a Holter monitor. The monitor records your heart's electrical activity as you go about your normal activities for 24 to 48 hours.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Duration:</strong> Holter monitoring usually lasts for 24 to 48 hours, although it can be longer depending on your specific condition. During this time, you will wear the Holter monitor and go about your daily routine as usual, including exercise and sleep.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong>  After the monitoring period is complete, your doctor will review the data collected by the Holter monitor to look for abnormal heart rhythms. They may also compare the results to your symptoms to help diagnose the underlying condition.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benifits:</strong> Holter monitoring provides a more comprehensive and extended view of your heart's electrical activity compared to a standard ECG test. This can help your doctor diagnose heart conditions that may not show up during a brief office visit.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> Holter monitoring is generally safe, but some people may experience skin irritation from the electrodes or discomfort from wearing the monitor. The electrodes may also come loose or fall off during the monitoring period, which can affect the accuracy of the test. In rare cases, people may experience an allergic reaction to the adhesive used to attach the electrodes</p>				
											</div>

										</div>


									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>
									
								</div>	<!-- END TAB-4 CONTENT -->

								<!-- TAB-5 CONTENT -->
								<div class="tab-pane fade show active" id="tab-5" role="tabpanel" aria-labelledby="tab5-list">

									<!-- Title -->
									<h3 class="h3-md steelblue-color">Dobutamine Stress Echocardiography</h3>

									<!-- Text -->
									<p>Dobutamine stress echocardiography (DSE) is a non-invasive medical test used to evaluate the heart's response to stress. It involves the use of dobutamine, a medication that mimics the effects of exercise on the heart, to increase the heart rate and blood flow while an echocardiogram is performed to assess the heart's function.
									</p>

									<!-- Image -->
									<div class="tab-img">
											<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/dse.jpg" alt="Dobutamine Stress Echocardiography" />
									</div>

									<!-- Text -->
									<p class="font-weight-bold">Here are some important things to know about DSE:
									</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of DSE is to evaluate the function of the heart during stress and detect any abnormalities that may not be apparent during rest. It is commonly used to diagnose and assess the severity of coronary artery disease, valvular heart disease, and other heart conditions.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for DSE, you may need to avoid eating or drinking for a few hours before the test. You may also be asked to avoid certain medications that could affect the results of the test. During the test, you will lie down on a table while a small intravenous (IV) line is inserted into your arm. A medication called dobutamine will be administered through the IV to increase your heart rate and simulate the effects of exercise. An echocardiogram will be performed before and after the administration of the medication.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Limitation:</strong> DSE is a safe and effective test, but it has some limitations. It is not recommended for people who have severe asthma or chronic obstructive pulmonary disease (COPD), as it can exacerbate breathing difficulties. It may also be less effective in people who have poor echocardiographic images due to obesity, lung disease, or other factors.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong>  After the test, the images obtained during the echocardiogram will be analyzed to assess the function of the heart at rest and during stress. The results can help your doctor diagnose or evaluate the severity of heart conditions such as coronary artery disease or heart valve problems.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benifits:</strong> DSE is a non-invasive and relatively safe way to assess the function of the heart during stress, without the risks associated with actual exercise. It can provide valuable information that may not be apparent during rest, which can aid in the diagnosis and management of heart conditions.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> DSE is generally safe, but some people may experience side effects from the medication, such as headaches, nausea, or palpitations. Rarely, serious complications such as arrhythmias, heart attack, or stroke may occur. However, these complications are extremely rare and occur in less than 1% of cases.</p>				
											</div>

										</div>


									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>
									
								</div>	<!-- END TAB-5 CONTENT -->

								<!-- TAB-5 CONTENT -->
								<div class="tab-pane fade" id="tab-6" role="tabpanel" aria-labelledby="tab6-list">

									<!-- Title -->
									<h3 class="h3-md steelblue-color">Pulmonary Function Test</h3>

									<!-- Text -->
									<p>PFT stands for Pulmonary Function Test, a non-invasive medical test used to evaluate lung function. It measures the amount of air you can inhale and exhale, the speed of your breath, and how effectively your lungs transfer oxygen into your bloodstream.
									</p>

									<!-- Image -->
									<div class="tab-img">
										<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/pulmonary.jpg" alt="Pulmonary Function Test" />
									</div>

									<!-- Text -->
									<p class="font-weight-bold">Here are some important things to know about PFT:
									</p>

									<!-- Options List -->
									<div class="row">

										<div class="col-xl-12">

											<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of PFT is to assess lung function, diagnose lung diseases such as asthma, chronic obstructive pulmonary disease (COPD), or pulmonary fibrosis, and monitor the effectiveness of treatment. It is also used to evaluate lung function before surgery or to assess the impact of environmental or occupational exposure on lung function.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for PFT, you may need to avoid smoking or using bronchodilators for several hours before the test. The test is performed by breathing into a device called a spirometer, which measures the volume and speed of your breath. You may also be asked to perform other breathing maneuvers, such as rapid and deep breathing or holding your breath for several seconds.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Type of PFT:</strong> There are several types of PFT, including spirometry, lung volume measurement, diffusion capacity measurement, and bronchial provocation testing. Each type of PFT measures a different aspect of lung function and may be used to diagnose different lung conditions.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong>  After the test, the results are analyzed to evaluate lung function and diagnose any underlying conditions. Your doctor may compare the results to normal values based on your age, height, weight, and sex. They may also compare your results to previous PFTs to monitor changes in lung function over time.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benifits:</strong> PFT is a non-invasive and relatively safe way to assess lung function, which can help diagnose and manage lung conditions. It can provide valuable information that may not be apparent from physical examination or imaging tests.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> PFT is generally safe, but some people may experience dizziness, lightheadedness, or shortness of breath during the test. Rarely, serious complications such as a collapsed lung may occur. However, these complications are extremely rare and occur in less than 1% of cases.</p>				
											</div>

										</div>


									</div>	<!-- End Options List -->

									<!-- Button -->
									<a href="<?=base_url();?>appointment" class="btn btn-blue blue-hover mt-30">Book Appointment</a>
									
								</div>	<!-- END TAB-6 CONTENT -->


							</div>	<!-- END TABS CONTENT -->


			 			</div>	
				 	</div>     <!-- End row -->	
				</div>     <!-- End container -->	
			</section>	<!-- END TABS-2 -->
            <?= $this->endSection(); ?>

