
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item"><a href="<?=base_url('our-services');?>">Our Services</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Electrocardiogram</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Electrocardiogram</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	



<!-- SERVICE DETAILS
			============================================= -->
			<div id="service-page" class="wide-60 service-page-section division">
				<div class="container">
					<div class="row">


						<!-- SERVICE CONTENT -->
				 		<div class="col-lg-8">
				 			<div class="s2-page pr-30 mb-40">

				 				<!-- Title -->
								<h3 class="h3-md blue-color">Electrocardiogram(ECG)</h3>
								<!--<h4 class="h4-sm blue-color">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time.-->
								<!--</h4>-->

								<!-- Text -->
								<p>An electrocardiogram (ECG or EKG) is a medical test that measures the electrical activity of the heart. It is a non-invasive procedure that helps in diagnosing various heart conditions and assessing heart health. The ECG records the electrical signals generated by the heart as it beats, and the resulting graph is called an electrocardiogram.</p>
                                 
                                <p>During an ECG, small electrodes are placed on specific locations on the patient's chest, arms, and legs. These electrodes are connected to a machine that detects and amplifies the electrical signals from the heart. The machine then converts these signals into a visual representation on a graph or a monitor.</p>

				 				<!-- Image -->
								<div class="content-block-img text-center">
									<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/holter-monitoring.jpg" alt="Holter Monitoring" />
								</div>
								<h5 class="h5-md blue-color">Electrical Activity</h5>
                                 <p class="blue-color">The typical ECG graph consists of several waves and segments that represent different aspects of the heart's electrical activity. These include:</p>
                              
								<!-- Options List -->
								<div class="row">

									<div class="col-xl-12">

										<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>P Wave:</strong> Represents the depolarization (contraction) of the atria.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>QRS Complex:</strong> Represents the depolarization of the ventricles.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>T Wave:</strong> Represents the repolarization (recovery) of the ventricles.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>PR Interval:</strong> Measures the time it takes for the electrical signal to travel from the atria to the ventricles.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>QT Interval:</strong> Measures the time it takes for ventricular depolarization and repolarization.
By analyzing the shape, duration, and timing of these waves and intervals, healthcare professionals can identify abnormal heart rhythms (arrhythmias), poor blood flow to the heart muscle (ischemia), structural abnormalities, electrolyte imbalances, and other cardiac conditions.</p>				
											</div>
											

									</div>
									<p>ECGs are commonly performed in various healthcare settings, including hospitals, clinics, and doctor's offices. They are often part of routine check-ups, preoperative evaluations, and assessments of individuals with heart-related symptoms such as chest pain, palpitations, or shortness of breath. ECGs are an essential tool in diagnosing and monitoring heart conditions and guiding treatment decisions.</p>

								</div>	<!-- End Options List -->

								<!-- Picing Table -->
								<div class="pricing-table d-none">	
									<table class="table table-hover">
										<thead>
										    <tr>
										      	<th scope="col">#</th>
										      	<th scope="col">Service</th>
										      	<th scope="col">Price</th>
										    </tr>
										</thead>
										<tbody>
										    <tr>
										      	<th scope="row">1</th>
										     	<td>Bronchoscopy</td>
										      	<td>From <span>$1340.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">2</th>
										      	<td>Parathyroid Scan</td>
										      	<td>From <span>$765.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">3</th>
										      	<td>Echocardiography</td>
										      	<td>From <span>$1075.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">4</th>
										      	<td>Full Blood Picture</td>
										      	<td>From <span>$950.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">5</th>
										      	<td>CT & Ultrasound Diagnostic</td>
										      	<td>From <span>$885.00</span></td>
										    </tr>
										    <tr class="last-tr">
										      	<th scope="row">6</th>
										      	<td>MRI & X-Ray</td>
										      	<td>From <span>$1050.00</span></td>
										    </tr>
										</tbody>
									</table>
								</div>
				 				
				 			</div>
				 		</div>	<!-- END SERVICE CONTENT --> 	


				 		<!-- SIDEBAR -->
						<aside id="sidebar" class="col-lg-4">
							<div id="txt-widget" class="sidebar-div mb-50">
								<h5 class="h5-sm steelblue-color text-uppercase">Book An Investigation</h5>
<?php if(session()->has('msg')){ ?>
   <div class="alert <?= session()->getFlashdata('alert-class') ?>">
      <?= session()->getFlashdata('msg') ?>
   </div>
<?php } ?>
		
								<?=form_open(base_url('/appointment'), ['class' => "row appointment-form"]); ?>
										<div id="input-clinic" class="col-md-12 input-clinic">
						                    <select id="inlineFormCustomSelect0" name="clinic_name" class="custom-select clinic" required>
						                      	<option value="C1" selected>Zutshi Heart Clinic & Diagnostic Centre</option>
						                    </select>
						                </div>
						                <div id="input-service" class="col-md-12 input-service">
						                    <select id="inlineFormCustomSelect1" name="service" class="custom-select service" required>
						                      	<option value="ECG" selected>ECG</option>
						                    </select>
						                </div>
						                 <!-- Form Select -->
						                <div id="input-patient" class="col-md-12 input-patient">
						                    <select id="inlineFormCustomSelect3" name="patient" class="custom-select patient" required>
						                        <option value="">Have You Visited Us Before?*</option>
												<option value="new">New Patient</option>
												<option value="old">Returning Patient</option>
												<option value="other">Other</option>
						                    </select>
						                </div>

						                <!-- Contact Form Input -->
						                <div id="input-date" class="col-lg-6">
						                	<input id="datepicker" type="date" min="2023-05-17" name="appointment_date" class="form-control date" placeholder="Appointment Date"> 
											<span style="color: red;"></span>
						                </div>
						                 <div id="input-date" class="col-lg-6">
						                	<input id="timepicker" type="time" name="appointment_time" class="form-control time" placeholder="Appointment Time"> 
											<span style="color: red;"></span>
						                </div>
				                                            
						                <!-- Contact Form Input -->
						                <div id="input-name" class="col-lg-12">
										    <input type="text" name="name" value="" class="form-control name" placeholder="Enter Your Full Name*" id="name">
											
						                </div>
						                        
						                <div id="input-email" class="col-lg-12">
						                	<input type="text" name="email" class="form-control email" placeholder="Enter Your Email*" required> 
						                </div>

						                <div id="input-phone" class="col-lg-12">
						                	<input type="tel" name="phone" class="form-control phone" placeholder="Enter Your Phone Number*" required> 
						                </div>						                          
						                        
						                <div id="input-msg" class="col-lg-12 input-msg">
						                	<textarea class="form-control msg" name="msg" rows="6" placeholder="Your Message ..."></textarea>
						                </div> 
						                                            
						                <!-- Contact Form Button -->
						                <div class="col-lg-12 form-btn">  
						                	<button type="submit" class="btn btn-blue blue-hover submit">Book An Investigation</button> 
						                </div>
						                                                              
						                <!-- Contact Form Message -->
						                <div class="col-lg-12 appointment-form-msg text-center">
						                	<div class="sending-msg"><span class="loading"></span></div>
						                </div>  
					                                              
									<?=form_close();?>									
							</div>

						</aside>   <!-- END SIDEBAR -->	


				 	</div>  <!-- End row -->	
				</div>	<!-- End container -->	
			</div>	<!-- END SERVICE DETAILS -->

            <?= $this->endSection(); ?>

