
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item"><a href="<?=base_url('our-services');?>">Our Services</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Echocardiogram</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Echocardiogram</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	



<!-- SERVICE DETAILS
			============================================= -->
			<div id="service-page" class="wide-60 service-page-section division">
				<div class="container">
					<div class="row">


						<!-- SERVICE CONTENT -->
				 		<div class="col-lg-8">
				 			<div class="s2-page pr-30 mb-40">

				 				<!-- Title -->
								<h3 class="h3-md blue-color">Echocardiogram(ECHO)</h3>
								<!--<h4 class="h4-sm blue-color">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time.-->
								<!--</h4>-->

								<!-- Text -->
								<p>Echocardiography is a medical imaging technique that uses sound waves (ultrasound) to create detailed images of the heart. It provides valuable information about the structure, function, and blood flow of the heart. Echocardiograms are commonly referred to as "echo" for short.</p>
                                 
                                <p>During an echocardiogram, a trained technician or a cardiac sonographer places a small handheld device called a transducer on the patient's chest. The transducer emits high-frequency sound waves that penetrate the chest and bounce back when they encounter different tissues and structures within the heart. These sound waves are then converted into real-time images on a monitor.</p>

				 				<!-- Image -->
								<div class="content-block-img text-center">
									<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/holter-monitoring.jpg" alt="Holter Monitoring" />
								</div>
								<h5 class="h5-md blue-color">Echocardiography</h5>
                                 <p class="blue-color">There are several types of echocardiography, including:</p>
                              
								<!-- Options List -->
								<div class="row">

									<div class="col-xl-12">

										<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Transthoracic echocardiography (TTE):</strong> This is the most common type of echocardiogram. The transducer is placed on the chest wall to obtain images of the heart's structures, including the chambers, valves, and major blood vessels. TTE is non-invasive and does not involve any injections or radiation exposure.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Transesophageal echocardiography (TEE):</strong> In this procedure, a specialized transducer is passed through the mouth and into the esophagus, which is located directly behind the heart. TEE provides clearer and more detailed images of the heart because the sound waves do not have to pass through the chest wall. It is often used when a more detailed evaluation of the heart's structures is required, such as assessing valve function or detecting blood clots.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Stress echocardiography:</strong> This type of echocardiogram is performed while the patient is exercising or undergoing a pharmacological stress test. It helps evaluate the heart's function and blood flow during increased levels of activity or stress.
</p>				
											</div>
											

									</div>

								</div>	<!-- End Options List -->
								<p>Echocardiography can provide valuable information about the heart's size, shape, and pumping ability (ejection fraction). It can also detect abnormalities such as heart valve problems, heart muscle disorders (cardiomyopathies), congenital heart defects, and fluid accumulation around the heart (pericardial effusion). Doppler echocardiography, a specific technique within echocardiography, can assess blood flow and detect abnormalities such as leaking or narrowed valves, abnormal blood flow patterns, and signs of heart failure.</p>
                                <p>Echocardiography is widely used in clinical practice, including in cardiology, primary care, and emergency medicine. It is a safe, non-invasive, and relatively low-cost imaging technique that provides valuable diagnostic information and helps guide treatment decisions for various heart conditions.</p>
								<!-- Picing Table -->
								<div class="pricing-table d-none">	
									<table class="table table-hover">
										<thead>
										    <tr>
										      	<th scope="col">#</th>
										      	<th scope="col">Service</th>
										      	<th scope="col">Price</th>
										    </tr>
										</thead>
										<tbody>
										    <tr>
										      	<th scope="row">1</th>
										     	<td>Bronchoscopy</td>
										      	<td>From <span>$1340.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">2</th>
										      	<td>Parathyroid Scan</td>
										      	<td>From <span>$765.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">3</th>
										      	<td>Echocardiography</td>
										      	<td>From <span>$1075.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">4</th>
										      	<td>Full Blood Picture</td>
										      	<td>From <span>$950.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">5</th>
										      	<td>CT & Ultrasound Diagnostic</td>
										      	<td>From <span>$885.00</span></td>
										    </tr>
										    <tr class="last-tr">
										      	<th scope="row">6</th>
										      	<td>MRI & X-Ray</td>
										      	<td>From <span>$1050.00</span></td>
										    </tr>
										</tbody>
									</table>
								</div>
				 				
				 			</div>
				 		</div>	<!-- END SERVICE CONTENT --> 	


				 		<!-- SIDEBAR -->
						<aside id="sidebar" class="col-lg-4">
							<div id="txt-widget" class="sidebar-div mb-50">
								<h5 class="h5-sm steelblue-color text-uppercase">Book An Investigation</h5>
<?php if(session()->has('msg')){ ?>
   <div class="alert <?= session()->getFlashdata('alert-class') ?>">
      <?= session()->getFlashdata('msg') ?>
   </div>
<?php } ?>
		
								<?=form_open(base_url('/appointment'), ['class' => "row appointment-form"]); ?>
										<div id="input-clinic" class="col-md-12 input-clinic">
						                    <select id="inlineFormCustomSelect0" name="clinic_name" class="custom-select clinic" required>
						                      	<option value="C1" selected>Zutshi Heart Clinic & Diagnostic Centre</option>
						                    </select>
						                </div>
						                <div id="input-service" class="col-md-12 input-service">
						                    <select id="inlineFormCustomSelect1" name="service" class="custom-select service" required>
						                      	<option value="ECHO" selected>ECHO</option>
						                    </select>
						                </div>
						                 <!-- Form Select -->
						                <div id="input-patient" class="col-md-12 input-patient">
						                    <select id="inlineFormCustomSelect3" name="patient" class="custom-select patient" required>
						                        <option value="">Have You Visited Us Before?*</option>
												<option value="new">New Patient</option>
												<option value="old">Returning Patient</option>
												<option value="other">Other</option>
						                    </select>
						                </div>

						                <!-- Contact Form Input -->
						                <div id="input-date" class="col-lg-6">
						                	<input id="datepicker" type="date" min="2023-05-17" name="appointment_date" class="form-control date" placeholder="Appointment Date"> 
											<span style="color: red;"></span>
						                </div>
						                 <div id="input-date" class="col-lg-6">
						                	<input id="timepicker" type="time" name="appointment_time" min="09:00" max="21:00" class="form-control time" placeholder="Appointment Time"> 
											<span style="color: red;"></span>
						                </div>
				                                            
						                <!-- Contact Form Input -->
						                <div id="input-name" class="col-lg-12">
										    <input type="text" name="name" value="" class="form-control name" placeholder="Enter Your Full Name*" id="name">
											
						                </div>
						                        
						                <div id="input-email" class="col-lg-12">
						                	<input type="text" name="email" class="form-control email" placeholder="Enter Your Email*" required> 
						                </div>

						                <div id="input-phone" class="col-lg-12">
						                	<input type="tel" name="phone" class="form-control phone" placeholder="Enter Your Phone Number*" required> 
						                </div>						                          
						                        
						                <div id="input-msg" class="col-lg-12 input-msg">
						                	<textarea class="form-control msg" name="msg" rows="6" placeholder="Your Message ..."></textarea>
						                </div> 
						                                            
						                <!-- Contact Form Button -->
						                <div class="col-lg-12 form-btn">  
						                	<button type="submit" class="btn btn-blue blue-hover submit">Book An Investigation</button> 
						                </div>
						                                                              
						                <!-- Contact Form Message -->
						                <div class="col-lg-12 appointment-form-msg text-center">
						                	<div class="sending-msg"><span class="loading"></span></div>
						                </div>  
					                                              
									<?=form_close();?>									
							</div>

						</aside>   <!-- END SIDEBAR -->	


				 	</div>  <!-- End row -->	
				</div>	<!-- End container -->	
			</div>	<!-- END SERVICE DETAILS -->

            <?= $this->endSection(); ?>

