
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item"><a href="<?=base_url('our-services');?>">Our Services</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Holter Monitoring</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Holter Monitoring</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	



<!-- SERVICE DETAILS
			============================================= -->
			<div id="service-page" class="wide-60 service-page-section division">
				<div class="container">
					<div class="row">


						<!-- SERVICE CONTENT -->
				 		<div class="col-lg-8">
				 			<div class="s2-page pr-30 mb-40">

				 				<!-- Title -->
								<h3 class="h3-md blue-color">Holter Monitoring</h3>
								<!--<h4 class="h4-sm blue-color">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time.-->
								<!--</h4>-->

								<!-- Text -->
								<p>Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time, usually 24 to 48 hours and up to 7 days using a small portable device called a Holter monitor. This type of monitoring is useful for detecting abnormal heart rhythms, which can be symptoms of various heart conditions such as arrhythmias, palpitations, or syncope.
								</p>


				 				<!-- Image -->
								<div class="content-block-img text-center">
									<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/holter-monitoring.jpg" alt="Holter Monitoring" />
								</div>
								<h5 class="h5-md blue-color">Know about Holter Monitoring</h5>
                                 <p class="blue-color">Here are some important things to know about Holter Monitoring:</p>
                              
								<!-- Options List -->
								<div class="row">

									<div class="col-xl-12">

										<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of Holter monitoring is to record and analyze the electrical activity of your heart over a period of time. This helps your doctor diagnose abnormal heart rhythms that may not show up during a standard electrocardiogram (ECG) test.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for Holter monitoring, you may need to avoid applying lotions or oils to your chest and avoid taking a bath or shower. The technician will attach electrodes to your chest, which are connected to a small, portable device called a Holter monitor. The monitor records your heart's electrical activity as you go about your normal activities for 24 to 48 hours.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Duration:</strong> Holter monitoring usually lasts for 24 to 48 hours, although it can be longer depending on your specific condition. During this time, you will wear the Holter monitor and go about your daily routine as usual, including exercise and sleep.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong>  After the monitoring period is complete, your doctor will review the data collected by the Holter monitor to look for abnormal heart rhythms. They may also compare the results to your symptoms to help diagnose the underlying condition.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benifits:</strong> Holter monitoring provides a more comprehensive and extended view of your heart's electrical activity compared to a standard ECG test. This can help your doctor diagnose heart conditions that may not show up during a brief office visit.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> Holter monitoring is generally safe, but some people may experience skin irritation from the electrodes or discomfort from wearing the monitor. The electrodes may also come loose or fall off during the monitoring period, which can affect the accuracy of the test. In rare cases, people may experience an allergic reaction to the adhesive used to attach the electrodes</p>				
											</div>

									</div>

								</div>	<!-- End Options List -->

								<!-- Picing Table -->
								<div class="pricing-table d-none">	
									<table class="table table-hover">
										<thead>
										    <tr>
										      	<th scope="col">#</th>
										      	<th scope="col">Service</th>
										      	<th scope="col">Price</th>
										    </tr>
										</thead>
										<tbody>
										    <tr>
										      	<th scope="row">1</th>
										     	<td>Bronchoscopy</td>
										      	<td>From <span>$1340.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">2</th>
										      	<td>Parathyroid Scan</td>
										      	<td>From <span>$765.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">3</th>
										      	<td>Echocardiography</td>
										      	<td>From <span>$1075.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">4</th>
										      	<td>Full Blood Picture</td>
										      	<td>From <span>$950.00</span></td>
										    </tr>
										    <tr>
										      	<th scope="row">5</th>
										      	<td>CT & Ultrasound Diagnostic</td>
										      	<td>From <span>$885.00</span></td>
										    </tr>
										    <tr class="last-tr">
										      	<th scope="row">6</th>
										      	<td>MRI & X-Ray</td>
										      	<td>From <span>$1050.00</span></td>
										    </tr>
										</tbody>
									</table>
								</div>
				 				
				 			</div>
				 		</div>	<!-- END SERVICE CONTENT --> 	


				 		<!-- SIDEBAR -->
						<aside id="sidebar" class="col-lg-4">
							<div id="txt-widget" class="sidebar-div mb-50">
								<h5 class="h5-sm steelblue-color text-uppercase">Book An Investigation</h5>
<?php if(session()->has('msg')){ ?>
   <div class="alert <?= session()->getFlashdata('alert-class') ?>">
      <?= session()->getFlashdata('msg') ?>
   </div>
<?php } ?>
		
								<?=form_open(base_url('/appointment'), ['class' => "row appointment-form"]); ?>
										<div id="input-clinic" class="col-md-12 input-clinic">
						                    <select id="inlineFormCustomSelect0" name="clinic_name" class="custom-select clinic" required>
						                      	<option value="C1" selected>Zutshi Heart Clinic & Diagnostic Centre</option>
						                    </select>
						                </div>
						                <div id="input-service" class="col-md-12 input-service">
						                    <select id="inlineFormCustomSelect1" name="service" class="custom-select service" required>
						                      	<option value="Holter Monitoring" selected>Holter Monitoring</option>
						                    </select>
						                </div>
						                 <!-- Form Select -->
						                <div id="input-patient" class="col-md-12 input-patient">
						                    <select id="inlineFormCustomSelect3" name="patient" class="custom-select patient" required>
						                        <option value="">Have You Visited Us Before?*</option>
												<option value="new">New Patient</option>
												<option value="old">Returning Patient</option>
												<option value="other">Other</option>
						                    </select>
						                </div>

						                <!-- Contact Form Input -->
						                <div id="input-date" class="col-lg-6">
						                	<input id="datepicker" type="date" min="2023-05-17" name="appointment_date" class="form-control date" placeholder="Appointment Date"> 
											<span style="color: red;"></span>
						                </div>
						                 <div id="input-date" class="col-lg-6">
						                	<input id="timepicker" type="time" name="appointment_time" class="form-control time" placeholder="Appointment Time"> 
											<span style="color: red;"></span>
						                </div>
				                                            
						                <!-- Contact Form Input -->
						                <div id="input-name" class="col-lg-12">
										    <input type="text" name="name" value="" class="form-control name" placeholder="Enter Your Full Name*" id="name">
											
						                </div>
						                        
						                <div id="input-email" class="col-lg-12">
						                	<input type="text" name="email" class="form-control email" placeholder="Enter Your Email*" required> 
						                </div>

						                <div id="input-phone" class="col-lg-12">
						                	<input type="tel" name="phone" class="form-control phone" placeholder="Enter Your Phone Number*" required> 
						                </div>						                          
						                        
						                <div id="input-msg" class="col-lg-12 input-msg">
						                	<textarea class="form-control msg" name="msg" rows="6" placeholder="Your Message ..."></textarea>
						                </div> 
						                                            
						                <!-- Contact Form Button -->
						                <div class="col-lg-12 form-btn">  
						                	<button type="submit" class="btn btn-blue blue-hover submit">Book An Investigation</button> 
						                </div>
						                                                              
						                <!-- Contact Form Message -->
						                <div class="col-lg-12 appointment-form-msg text-center">
						                	<div class="sending-msg"><span class="loading"></span></div>
						                </div>  
					                                              
									<?=form_close();?>									
							</div>

						</aside>   <!-- END SIDEBAR -->	


				 	</div>  <!-- End row -->	
				</div>	<!-- End container -->	
			</div>	<!-- END SERVICE DETAILS -->

            <?= $this->endSection(); ?>

