
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item"><a href="<?=base_url('our-services');?>">Our Services</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Pulmonary Function Test</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Pulmonary Function Test</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	



<!-- SERVICE DETAILS
			============================================= -->
			<div id="service-page" class="wide-60 service-page-section division">
				<div class="container">
					<div class="row">


						<!-- SERVICE CONTENT -->
				 		<div class="col-lg-8">
				 			<div class="s2-page pr-30 mb-40">

				 				<!-- Title -->
								<h3 class="h3-md blue-color">Pulmonary Function Test</h3>
								<!--<h4 class="h4-sm blue-color">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time.-->
								<!--</h4>-->

								<!-- Text -->
								<p>PFT stands for Pulmonary Function Test, a non-invasive medical test used to evaluate lung function. It measures the amount of air you can inhale and exhale, the speed of your breath, and how effectively your lungs transfer oxygen into your bloodstream.
									</p>


				 				<!-- Image -->
								<div class="content-block-img text-center">
									<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/pulmonary.jpg" alt="PFT" />
								</div>
								<h5 class="h5-md blue-color">Important things about PFT</h5>
                                 <p class="blue-color">Here are some important things to know about PFT:</p>
                              
								<!-- Options List -->
								<div class="row">

									<div class="col-xl-12">

									<!-- Option #1 -->
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Purpose:</strong> The purpose of PFT is to assess lung function, diagnose lung diseases such as asthma, chronic obstructive pulmonary disease (COPD), or pulmonary fibrosis, and monitor the effectiveness of treatment. It is also used to evaluate lung function before surgery or to assess the impact of environmental or occupational exposure on lung function.</p>							
											</div>

											<!-- Option #2 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Procedure:</strong> To prepare for PFT, you may need to avoid smoking or using bronchodilators for several hours before the test. The test is performed by breathing into a device called a spirometer, which measures the volume and speed of your breath. You may also be asked to perform other breathing maneuvers, such as rapid and deep breathing or holding your breath for several seconds.</p>			
											</div>

											<!-- Option #3 -->
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Type of PFT:</strong> There are several types of PFT, including spirometry, lung volume measurement, diffusion capacity measurement, and bronchial provocation testing. Each type of PFT measures a different aspect of lung function and may be used to diagnose different lung conditions.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Interpretation of results:</strong>  After the test, the results are analyzed to evaluate lung function and diagnose any underlying conditions. Your doctor may compare the results to normal values based on your age, height, weight, and sex. They may also compare your results to previous PFTs to monitor changes in lung function over time.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Benifits:</strong> PFT is a non-invasive and relatively safe way to assess lung function, which can help diagnose and manage lung conditions. It can provide valuable information that may not be apparent from physical examination or imaging tests.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Risks:</strong> PFT is generally safe, but some people may experience dizziness, lightheadedness, or shortness of breath during the test. Rarely, serious complications such as a collapsed lung may occur. However, these complications are extremely rare and occur in less than 1% of cases.</p>				
											</div>

									</div>

								</div>	<!-- End Options List -->
				 				
				 			</div>
				 		</div>	<!-- END SERVICE CONTENT --> 	


				 		<!-- SIDEBAR -->
						<aside id="sidebar" class="col-lg-4">
							<div id="txt-widget" class="sidebar-div mb-50">
								<h5 class="h5-sm steelblue-color text-uppercase">Book An Investigation</h5>
<?php if(session()->has('msg')){ ?>
   <div class="alert <?= session()->getFlashdata('alert-class') ?>">
      <?= session()->getFlashdata('msg') ?>
   </div>
<?php } ?>
		
								<?=form_open(base_url('/appointment'), ['class' => "row appointment-form"]); ?>
										<div id="input-clinic" class="col-md-12 input-clinic">
						                    <select id="inlineFormCustomSelect0" name="clinic_name" class="custom-select clinic" required>
						                      	<option value="C1" selected>Zutshi Heart Clinic & Diagnostic Centre</option>
						                    </select>
						                </div>
						                <div id="input-service" class="col-md-12 input-service">
						                    <select id="inlineFormCustomSelect1" name="service" class="custom-select service" required>
						                      	<option value="Pulmonary Function Test" selected>Pulmonary Function Test</option>
						                    </select>
						                </div>
						                 <!-- Form Select -->
						                <div id="input-patient" class="col-md-12 input-patient">
						                    <select id="inlineFormCustomSelect3" name="patient" class="custom-select patient" required>
						                        <option value="">Have You Visited Us Before?*</option>
												<option value="new">New Patient</option>
												<option value="old">Returning Patient</option>
												<option value="other">Other</option>
						                    </select>
						                </div>

						                <!-- Contact Form Input -->
						                <div id="input-date" class="col-lg-6">
						                	<input id="datepicker" type="date" min="2023-05-17" name="appointment_date" class="form-control date" placeholder="Appointment Date"> 
											<span style="color: red;"></span>
						                </div>
						                 <div id="input-date" class="col-lg-6">
						                	<input id="timepicker" type="time" name="appointment_time" class="form-control time" placeholder="Appointment Time"> 
											<span style="color: red;"></span>
						                </div>
				                                            
						                <!-- Contact Form Input -->
						                <div id="input-name" class="col-lg-12">
										    <input type="text" name="name" value="" class="form-control name" placeholder="Enter Your Full Name*" id="name">
											
						                </div>
						                        
						                <div id="input-email" class="col-lg-12">
						                	<input type="text" name="email" class="form-control email" placeholder="Enter Your Email*" required> 
						                </div>

						                <div id="input-phone" class="col-lg-12">
						                	<input type="tel" name="phone" class="form-control phone" placeholder="Enter Your Phone Number*" required> 
						                </div>						                          
						                        
						                <div id="input-msg" class="col-lg-12 input-msg">
						                	<textarea class="form-control msg" name="msg" rows="6" placeholder="Your Message ..."></textarea>
						                </div> 
						                                            
						                <!-- Contact Form Button -->
						                <div class="col-lg-12 form-btn">  
						                	<button type="submit" class="btn btn-blue blue-hover submit">Book An Investigation</button> 
						                </div>
						                                                              
						                <!-- Contact Form Message -->
						                <div class="col-lg-12 appointment-form-msg text-center">
						                	<div class="sending-msg"><span class="loading"></span></div>
						                </div>  
					                                              
									<?=form_close();?>									
							</div>

						</aside>   <!-- END SIDEBAR -->	


				 	</div>  <!-- End row -->	
				</div>	<!-- End container -->	
			</div>	<!-- END SERVICE DETAILS -->

            <?= $this->endSection(); ?>

		