
<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
			<div id="breadcrumb" class="division">
				<div class="container">
					<div class="row">						
						<div class="col">
							<div class=" breadcrumb-holder">

								<!-- Breadcrumb Nav -->
								<nav aria-label="breadcrumb">
								  	<ol class="breadcrumb">
								    	<li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
								    	<li class="breadcrumb-item"><a href="<?=base_url('our-services');?>">Our Services</a></li>
								    	<li class="breadcrumb-item active" aria-current="page">Stress Echocardiogram</li>
								  	</ol>
								</nav>

								<!-- Title -->
								<h4 class="h4-sm steelblue-color">Stress Echocardiogram</h4>

							</div>
						</div>
					</div>  <!-- End row -->	
				</div>	<!-- End container -->		
			</div>	<!-- END BREADCRUMB -->	



<!-- SERVICE DETAILS
			============================================= -->
			<div id="service-page" class="wide-60 service-page-section division">
				<div class="container">
					<div class="row">


						<!-- SERVICE CONTENT -->
				 		<div class="col-lg-8">
				 			<div class="s2-page pr-30 mb-40">

				 				<!-- Title -->
								<h3 class="h3-md blue-color">Stress Echocardiogram</h3>
								<!--<h4 class="h4-sm blue-color">Holter monitoring is a non-invasive medical test that measures and records a patient's heart rhythm over a period of time.-->
								<!--</h4>-->

								<!-- Text -->
								<p class="text-justify">A stress echocardiogram (stress echo) is a medical test that combines a standard echocardiogram with an exercise stress test to evaluate how well your heart functions under stress. While stress echocardiogram is a useful tool in diagnosing heart problems, there are some limitations to the test. 
									</p>


				 				<!-- Image -->
								<div class="content-block-img text-center">
									<img class="img-fluid rounded shadow-lg" src="<?=base_url();?>uploads/services/banner/stress-echo.jpg" alt="Stress Echo" />
								</div>
								<h5 class="h5-md blue-color">Instructions of stress echocardiogram</h5>
                                <p class="blue-color">Here are some of the limitations and instructions related to stress echocardiogram:</p>
								<div class="row">
									<div class="col-xl-12">
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False positive results:</strong> In some cases, stress echocardiogram may show abnormalities that are not actually present. This can happen if there is an error in the test, or if there are other underlying health conditions that can cause similar symptoms.</p>							
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>False negative results:</strong> In some cases, stress echocardiogram may not detect underlying heart problems that are present. This can happen if the blockage is very small or if it is located in an area that is difficult to see with the test.</p>			
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p><strong>Limited visualization:</strong> Stress echocardiogram provides limited visualization of the heart compared to other imaging tests such as CT or MRI. The image quality may also be reduced during exercise when the heart rate is high.</p>				
											</div>
									</div>
								</div>
								<h5 class="h5-md blue-color">Limitations of stress echocardiogram</h5>
								<div class="row">
									<div class="col-xl-12">
											<div class="box-list">							
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Avoid food and drinks for 4 hours prior to the test.</p>							
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Wear comfortable clothing and shoes suitable for exercise.</p>			
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Inform your doctor about any medications you are taking, especially if you are taking medications for heart problems.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>Do not smoke, drink caffeine, or take any stimulants for at least 4 hours prior to the test.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>During the test, you will be asked to walk on a treadmill or pedal a stationary bike while your heart rate is monitored. The exercise may be stopped if you experience chest pain, shortness of breath, or other symptoms.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>After the exercise, you will lie down and a technician will perform an echocardiogram to assess how well your heart is functioning.</p>				
											</div>
											<div class="box-list">	
												<div class="box-list-icon blue-color"><i class="fas fa-angle-double-right"></i></div>
												<p>The entire test usually takes about an hour, and you should be able to return to your normal activities immediately afterward.</p>				
											</div>
									</div>
								</div>
				 				
				 			</div>
				 		</div>	<!-- END SERVICE CONTENT --> 	


				 		<!-- SIDEBAR -->
						<aside id="sidebar" class="col-lg-4">
							<div id="txt-widget" class="sidebar-div mb-50">
								<h5 class="h5-sm steelblue-color text-uppercase">Book An Investigation</h5>
<?php if(session()->has('msg')){ ?>
   <div class="alert <?= session()->getFlashdata('alert-class') ?>">
      <?= session()->getFlashdata('msg') ?>
   </div>
<?php } ?>
		
								<?=form_open(base_url('/appointment'), ['class' => "row appointment-form"]); ?>
										<div id="input-clinic" class="col-md-12 input-clinic">
						                    <select id="inlineFormCustomSelect0" name="clinic_name" class="custom-select clinic" required>
						                      	<option value="C1" selected>Zutshi Heart Clinic & Diagnostic Centre</option>
						                    </select>
						                </div>
						                <div id="input-service" class="col-md-12 input-service">
						                    <select id="inlineFormCustomSelect1" name="service" class="custom-select service" required>
						                      	<option value="Stress Echocardiogram" selected>Stress Echocardiogram</option>
						                    </select>
						                </div>
						                 <!-- Form Select -->
						                <div id="input-patient" class="col-md-12 input-patient">
						                    <select id="inlineFormCustomSelect3" name="patient" class="custom-select patient" required>
						                        <option value="">Have You Visited Us Before?*</option>
												<option value="new">New Patient</option>
												<option value="old">Returning Patient</option>
												<option value="other">Other</option>
						                    </select>
						                </div>

						                <!-- Contact Form Input -->
						                <div id="input-date" class="col-lg-6">
						                	<input id="datepicker" type="date" min="2023-05-17" name="appointment_date" class="form-control date" placeholder="Appointment Date"> 
											<span style="color: red;"></span>
						                </div>
						                 <div id="input-date" class="col-lg-6">
						                	<input id="timepicker" type="time" name="appointment_time" class="form-control time" placeholder="Appointment Time"> 
											<span style="color: red;"></span>
						                </div>
				                                            
						                <!-- Contact Form Input -->
						                <div id="input-name" class="col-lg-12">
										    <input type="text" name="name" value="" class="form-control name" placeholder="Enter Your Full Name*" id="name">
											
						                </div>
						                        
						                <div id="input-email" class="col-lg-12">
						                	<input type="text" name="email" class="form-control email" placeholder="Enter Your Email*" required> 
						                </div>

						                <div id="input-phone" class="col-lg-12">
						                	<input type="tel" name="phone" class="form-control phone" placeholder="Enter Your Phone Number*" required> 
						                </div>						                          
						                        
						                <div id="input-msg" class="col-lg-12 input-msg">
						                	<textarea class="form-control msg" name="msg" rows="6" placeholder="Your Message ..."></textarea>
						                </div> 
						                                            
						                <!-- Contact Form Button -->
						                <div class="col-lg-12 form-btn">  
						                	<button type="submit" class="btn btn-blue blue-hover submit">Book An Investigation</button> 
						                </div>
						                                                              
						                <!-- Contact Form Message -->
						                <div class="col-lg-12 appointment-form-msg text-center">
						                	<div class="sending-msg"><span class="loading"></span></div>
						                </div>  
					                                              
									<?=form_close();?>									
							</div>

						</aside>   <!-- END SIDEBAR -->	


				 	</div>  <!-- End row -->	
				</div>	<!-- End container -->	
			</div>	<!-- END SERVICE DETAILS -->

            <?= $this->endSection(); ?>

					