<?= $this->extend('frontend/template'); ?>
<?= $this->section('content'); ?>
<style>
    .author-senoff {
        padding: 20px;
        margin-top: 0px;
    }
</style>
<div id="breadcrumb" class="division">
    <div class="container">
        <div class="row">
            <div class="col">
                <div class="breadcrumb-holder">
                    <!-- Breadcrumb Nav -->
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?=base_url();?>">Home</a></li>
                            <li class="breadcrumb-item"><a href="<?=base_url('zutshi-lab');?>">Zutshi Lab</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Test</li>
                        </ol>
                    </nav>

                    <!-- Title -->
                    <h4 class="h4-sm steelblue-color"><?=$row['title'];?></h4>
                </div>
            </div>
        </div> <!-- End row -->
    </div> <!-- End container -->
</div> <!-- END BREADCRUMB -->

<div id="single-blog-page" class="wide-100 blog-page-section division">
    <div class="container">
        <div class="row">
            <!-- SINGLE POST -->
            <div class="col-lg-8">
                <ul id="tabsJustified" class="nav nav-tabs nav-fill">
                    <li class="nav-item"><a href="" data-target="#tab1" data-toggle="tab"
                            class="nav-link large font-weight-bold text-uppercase active">Introduction</a></li>
                <?php if($tc){ ?>
                    <li class="nav-item"><a href="" data-target="#tab2" data-toggle="tab"
                            class="nav-link large font-weight-bold text-uppercase ">Test Criteria</a></li>
                <?php } ?>
                <?php if($tp){ ?>
                    <li class="nav-item"><a href="" data-target="#tab3" data-toggle="tab"
                            class="nav-link large font-weight-bold text-uppercase">Test Parameters</a></li>
                <?php } ?>
                <?php if($qa){ ?>
                    <li class="nav-item"><a href="" data-target="#tab4" data-toggle="tab"
                            class="nav-link large font-weight-bold text-uppercase">Q&A</a></li>
                <?php } ?>
                </ul>

                <div class="single-blog-post pr-30">
                    <div id="tabsJustifiedContent" class="tab-content">
                        <div id="tab1" class="tab-pane fade active show">
                            <div class="sblog-post-txt mt-5">
                                <h5 class="h5-xl blue-color"><?=$row['title']; ?></h5>
                                <p class="mt-30"><?=$row['short_desc']; ?></p>
                                <?=$row['long_desc']; ?>
                            <div class="row">
			 					<div class="col-md-6">
			 						<div class="sbox-7 icon-xs wow fadeInUp" data-wow-delay="0.4s">
											<span class="flaticon-047-head blue-color"></span>
											<div class="sbox-7-txt">
												<h5 class="h5-sm steelblue-color">Fasting</h5>
												<p class="p-sm"><?=$row['fasting'];?></p>
											</div>
			 						</div>
			 					</div>  <!-- END SERVICE BOX #1 -->
                                 <div class="col-md-6">
			 						<div class="sbox-7 icon-xs wow fadeInUp" data-wow-delay="0.4s">
											<span class="flaticon-132-medicine-book blue-color"></span>
											<div class="sbox-7-txt">
												<h5 class="h5-sm steelblue-color">Get Reports In</h5>
												<p class="p-sm"><?=$row['gri'];?></p>
											</div>
			 						</div>
			 					</div>  <!-- END SERVICE BOX #1 -->
                            </div>
                            <div class="row">
			 					<div class="col-md-6">
			 						<div class="sbox-7 icon-xs wow fadeInUp" data-wow-delay="0.4s">
											<span class="flaticon-142-ambulance blue-color"></span>
											<div class="sbox-7-txt">
												<h5 class="h5-sm steelblue-color">Home Collection</h5>
												<p class="p-sm"><?=$row['hc'];?></p>
											</div>
			 						</div>
			 					</div>  <!-- END SERVICE BOX #1 -->
                                 <div class="col-md-6">
			 						<div class="sbox-7 icon-xs wow fadeInUp" data-wow-delay="0.4s">
											<span class="flaticon-092-clock blue-color"></span>
											<div class="sbox-7-txt">
												<h5 class="h5-sm steelblue-color">Age Group</h5>
												<p class="p-sm"><?=$row['ag'];?></p>
											</div>
			 						</div>
			 					</div>  <!-- END SERVICE BOX #1 -->
                            </div>
                               
                                <div class="blog-post-img mb-40">
                                <?php if(!empty($row['banner'])){ ?>
                                    <img class="img-fluid" src="<?=base_url('uploads/'.$row['banner']); ?>" alt="<?=$row['title']; ?>" />
                                <?php } ?>
                                </div>
                            </div> <!-- END BLOG POST TEXT -->
                        </div>
                        <div id="tab2" class="tab-pane fade faqs-section">
                            <div id="faqs-page" class="questions-holder pr-30 mt-5">
                                <h5 class="h5-xl blue-color">Test Criteria</h5>
                                <!--<p class="mt-30">Helps you know your test better</p>-->
                                <div id="accordion" role="tablist">
                            <?php foreach($tc as $key =>$value): ?>
                                    <div class="card">
                                        <div class="card-header" role="tab" id="heading<?=$key; ?>">
                                            <h5 class="h5-xs">
                                                <a data-toggle="collapse" href="#collapse<?=$key; ?>" role="button"
                                                    aria-expanded="true" aria-controls="collapse<?=$key; ?>"><?php echo $value['question']; ?></a>
                                            </h5>
                                        </div>
                                        <div id="collapse<?=$key; ?>" class="collapse show" role="tabpanel"
                                            aria-labelledby="heading<?=$key; ?>" data-parent="#accordion">
                                            <div class="card-body">
                                                <?php echo $value['answer']; ?>
                                            </div>
                                        </div>
                                    </div> <!-- END ACCORDION CARD #1 -->
                            <?php endforeach; ?>
                                        
                                </div>
                            </div> <!-- END BLOG POST TEXT -->

                        </div>
                        <div id="tab3" class="tab-pane fade">
                        <div id="faqs-page" class="questions-holder pr-30 mt-5">
                                <h4 class="h4-lg steelblue-color">Test Parameters</h4>
                                <!--<p class="mt-30">Helps you know your test better</p>-->
                                <div id="accordion" role="tablist">
                                <?php foreach($tp as $key =>$value): ?>
                                    <div class="card">
                                        <div class="card-header" role="tab" id="heading<?=$key; ?>">
                                            <h5 class="h5-xs">
                                                <a data-toggle="collapse" href="#collapse<?=$key; ?>" role="button"
                                                    aria-expanded="true" aria-controls="collapse<?=$key; ?>"><?php echo $value['question']; ?></a>
                                            </h5>
                                        </div>
                                        <div id="collapse<?=$key; ?>" class="collapse show" role="tabpanel"
                                            aria-labelledby="heading<?=$key; ?>" data-parent="#accordion">
                                            <div class="card-body">
                                                <?php echo $value['answer']; ?>
                                            </div>
                                        </div>
                                    </div> <!-- END ACCORDION CARD #1 -->
                            <?php endforeach; ?>
                                </div>
                            </div> <!-- END BLOG POST TEXT -->

                        </div>
                        <div id="tab4" class="tab-pane fade">
                        <div id="faqs-page" class="questions-holder pr-30 mt-5">
                                <h5 class="h5-xl blue-color">Q&A</h5>
                                <!--<p class="mt-30">Helps you know your test better</p>-->
                                <div id="accordion" role="tablist">
                                <?php foreach($qa as $key =>$value): ?>
                                    <div class="card">
                                        <div class="card-header" role="tab" id="heading<?=$key; ?>">
                                            <h5 class="h5-xs">
                                                <a data-toggle="collapse" href="#collapse<?=$key; ?>" role="button"
                                                    aria-expanded="true" aria-controls="collapse<?=$key; ?>"><?php echo $value['question']; ?></a>
                                            </h5>
                                        </div>
                                        <div id="collapse<?=$key; ?>" class="collapse show" role="tabpanel"
                                            aria-labelledby="heading<?=$key; ?>" data-parent="#accordion">
                                            <div class="card-body">
                                                <?php echo $value['answer']; ?>
                                            </div>
                                        </div>
                                    </div> <!-- END ACCORDION CARD #1 -->
                            <?php endforeach; ?>
                                </div>
                            </div> <!-- END BLOG POST TEXT -->

                        </div>
                    </div>

                    <!-- RELATED POSTS -->
                    <div class="related-posts mt-5 d-none">

                        <!-- Title -->
                        <h5 class="h5-md steelblue-color">Recommended Packages</h5>
                        <div class="row">

                            <!-- BLOG POST #1 -->
                            <div class="col-md-6">
                                <div class="blog-post">

                                    <!-- BLOG POST IMAGE -->
                                    <div class="blog-post-img">
                                        <img class="img-fluid" src="images/blog/post-2-img.jpg" alt="blog-post-image" />
                                    </div>

                                    <!-- BLOG POST TEXT -->
                                    <div class="blog-post-txt">

                                        <!-- Post Title -->
                                        <h5 class="h5-sm steelblue-color"><a href="single-post.html">Your Health Is In
                                                Your Hands</a></h5>

                                        <!-- Post Data -->
                                        <span>Apr 28, 2019 by <span class="blue-color">Dr.Jonathan Barnes</span></span>

                                        <!-- Post Text -->
                                        <p>Quaerat neque purus ipsum neque dolor primis libero tempus impedit tempor
                                            blandit sapien at
                                            gravida donec ipsum, at porta justo...
                                        </p>

                                    </div>

                                </div>
                            </div> <!-- END  BLOG POST #1 -->


                            <!-- BLOG POST #2 -->
                            <div class="col-md-6">
                                <div class="blog-post">

                                    <!-- BLOG POST IMAGE -->
                                    <div class="blog-post-img">
                                        <img class="img-fluid" src="images/blog/post-3-img.jpg" alt="blog-post-image" />
                                    </div>

                                    <!-- BLOG POST TEXT -->
                                    <div class="blog-post-txt">

                                        <!-- Post Title -->
                                        <h5 class="h5-sm steelblue-color"><a href="single-post.html">How Weather Impacts
                                                Your Health</a></h5>

                                        <!-- Post Data -->
                                        <span>Apr 17, 2019 by <span class="blue-color">Dr.Megan Coleman</span></span>

                                        <!-- Post Text -->
                                        <p>Quaerat neque purus ipsum neque dolor primis libero tempus impedit tempor
                                            blandit sapien at
                                            gravida donec ipsum, at porta justo...
                                        </p>

                                    </div>

                                </div>
                            </div> <!-- END  BLOG POST #2 -->

                        </div> <!-- End row -->

                    </div> <!-- END RELATED POSTS -->


                </div>
            </div> <!-- END SINGLE POST -->

            <!-- SIDEBAR -->
            <aside id="sidebar" class="col-lg-4 ">
                <!-- TEXT WIDGET -->
                <div id="txt-widget" class="sidebar-div mb-50 author-senoff">
                    <div class="blog-categories sidebar-div mb-50">
                        <ul class="blog-category-list clearfix"><i class="fa-solid fa-indian-rupee-sign"></i>
                           <?php
                               $percent = (($row['price'] - $row['sprice'])*100) /$row['price'] ;
                           ?>
                            <li>
                                <a href="#"><i class="fas fa-rupee-sign blue-color"></i><?php echo $row['sprice'];?>
                                    <sub><del><?php echo $row['price'];?></del></sub></a><span class="float-right"><?=round($percent); ?>%
                                    <sub>Off</sub></span>
                            </li>
                            <li>
                                <a href="#">Offer Price</a><span class="float-right"><i
                                        class="fas fa-rupee-sign blue-color"></i> <?php echo $row['sprice'];?></span>
                            </li>
                            <li>
                                <a href="#">Amount to be Paid</a><span class="float-right"><i
                                        class="fas fa-rupee-sign blue-color"></i> <?php echo $row['sprice'];?></span>
                            </li>
                        </ul>

                    </div>
                    <p><small>*inclusive of all the taxes, fees and subject to availability</small></p>
                    <a href="<?=base_url('cart/add/'.$row['id']);?>" class="btn btn-blue blue-hover btn-block">ADD</a>

                </div> <!-- END TEXT WIDGET -->
            </aside> <!-- END SIDEBAR -->


        </div> <!-- End row -->
    </div> <!-- End container -->
</div> <!-- END BLOG PAGE CONTENT -->



<?= $this->endSection(); ?>